/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import rescuecore.tools.mapgenerator.PairHeap;
import rescuecore.tools.mapgenerator.RescueMap;
import rescuecore.tools.mapgenerator.RoadWeighter;

public class AntsRoadWeighter
implements RoadWeighter {
    private static final int RUNS = 15000;
    private static final int THREELANE = 10;
    private static final int TWOLANE = 20;
    private int[][] usedCount;
    private int[][] distances;

    @Override
    public void connect(RescueMap rm, int uniformity, boolean nooneway, Random rand) {
        int nodes = rm.getNodeCount();
        this.distances = new int[nodes][nodes];
        for (int i = 0; i < nodes; ++i) {
            for (int j = 0; j < i; ++j) {
                int x = rm.getX(i) - rm.getX(j);
                int y = rm.getY(i) - rm.getY(j);
                this.distances[i][j] = (int)Math.sqrt(x * x + y * y);
                this.distances[j][i] = this.distances[i][j];
            }
        }
        this.usedCount = new int[nodes][nodes];
        System.out.print("Simulating road use.");
        System.out.flush();
        int steps = 750;
        int[] prevs = new int[nodes];
        int[] dists = new int[nodes];
        for (int i = 0; i < 15000; ++i) {
            int[] picked = this.pickNodes(rm, rand);
            this.runPath(prevs, dists, rm, picked[0], picked[1]);
            if (i % steps != 0) continue;
            System.out.print(".");
            System.out.flush();
        }
        System.out.println("done.");
        ArrayList<Integer> l = new ArrayList<Integer>(nodes * 5);
        for (int i = 0; i < nodes; ++i) {
            for (int j = 0; j < nodes; ++j) {
                if (rm.getRoad(i, j) <= 0) continue;
                l.add(new Integer(this.usedCount[i][j]));
            }
        }
        Collections.sort(l);
        int index1 = (int)((double)l.size() * 0.9);
        int v1 = (Integer)l.get(index1);
        int v2 = (Integer)l.get(index1 - (int)((double)(l.size() * 20) / 100.0));
        for (int i = 0; i < nodes; ++i) {
            for (int j = 0; j < nodes; ++j) {
                if (this.usedCount[i][j] >= v1 || nooneway && this.usedCount[j][i] >= v1) {
                    rm.setRoad(i, j, 3);
                    if (!nooneway) continue;
                    rm.setRoad(j, i, 3);
                    continue;
                }
                if (this.usedCount[i][j] < v2 && (!nooneway || this.usedCount[j][i] < v2)) continue;
                rm.setRoad(i, j, 2);
                if (!nooneway) continue;
                rm.setRoad(j, i, 2);
            }
        }
    }

    public int[] pickNodes(RescueMap rm, Random rand) {
        return new int[]{(int)(rand.nextDouble() * (double)rm.getNodeCount()), (int)(rand.nextDouble() * (double)rm.getNodeCount())};
    }

    private void runPath(int[] prevs, int[] dists, RescueMap rm, int start, int end) {
        int nodes = rm.getNodeCount();
        for (int i = 0; i < dists.length; ++i) {
            dists[i] = Integer.MAX_VALUE;
        }
        PairHeap q = new PairHeap();
        prevs[start] = -1;
        dists[start] = this.distances[start][end];
        int next = start;
        while (next != end) {
            for (int j = 0; j < nodes; ++j) {
                int guess;
                if (j == next || rm.getRoad(next, j) <= 0 || dists[j] <= (guess = dists[next] + this.distances[next][j] + this.distances[j][end])) continue;
                dists[j] = guess;
                prevs[j] = next;
                q.insert(j, guess);
            }
            next = q.deleteMin();
        }
        int prev = end;
        while (prevs[prev] != -1) {
            int[] nArray = this.usedCount[prevs[prev]];
            int n = prev;
            nArray[n] = nArray[n] + 1;
            prev = prevs[prev];
        }
    }
}

