/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import rescuecore.tools.simulationrunner.RescueProcess;

public class ProcessViewer
extends JPanel {
    private JTabbedPane tabs;
    private JTable summary;
    private ProcessTableModel model;
    private static final int PROCESS_COLUMN_NAME = 0;
    private static final int PROCESS_COLUMN_COMMAND = 1;
    private static final int PROCESS_COLUMN_STATUS = 2;
    private static final int PROCESS_COLUMN_COUNT = 3;
    private static final String[] PROCESS_COLUMN_NAMES = new String[]{"Name", "Command line", "Status"};

    public ProcessViewer(RescueProcess[] processes) {
        super(new BorderLayout());
        this.model = new ProcessTableModel(processes);
        this.summary = new JTable(this.model);
        this.tabs = new JTabbedPane();
        this.add((Component)new JScrollPane(this.summary), "Center");
        this.add((Component)this.tabs, "East");
    }

    public void processStarting(int index) {
        this.model.setStatus(index, "Starting");
    }

    public void processStarted(int index) {
        this.model.setStatus(index, "Running");
    }

    public void processStopped(int index) {
        this.model.setStatus(index, "Stopped");
    }

    private class ProcessTableModel
    extends AbstractTableModel {
        private String[] names;
        private String[] commands;
        private String[] statuses;

        ProcessTableModel(RescueProcess[] processes) {
            this.names = new String[processes.length];
            this.commands = new String[processes.length];
            this.statuses = new String[processes.length];
            for (int i = 0; i < processes.length; ++i) {
                this.names[i] = processes[i].getName();
                this.commands[i] = processes[i].getCommandLine();
                this.statuses[i] = "Not started";
            }
        }

        void setStatus(int index, String status) {
            this.statuses[index] = status;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.names.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.names[row];
                }
                case 1: {
                    return this.commands[row];
                }
                case 2: {
                    return this.statuses[row];
                }
            }
            throw new RuntimeException("Unknown column: " + col);
        }

        @Override
        public String getColumnName(int col) {
            return PROCESS_COLUMN_NAMES[col];
        }

        public Class getColumnClass(int col) {
            return String.class;
        }
    }
}

