/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import rescuecore.CannotFindLocationException;
import rescuecore.Memory;
import rescuecore.objects.Humanoid;
import rescuecore.view.MapRenderer;
import rescuecore.view.RenderTools;
import rescuecore.view.ScreenTransform;
import rescuecore.view.ViewConstants;

public abstract class HumanoidRenderer
implements MapRenderer {
    private static final HumanoidRenderer ORDINARY = new OrdinaryHumanoidRenderer();
    private static final int RADIUS = 5;
    private static final int DIAMETER = 11;

    public static HumanoidRenderer ordinaryHumanoidRenderer() {
        return ORDINARY;
    }

    public static HumanoidRenderer outlinedHumanoidRenderer(int outlineMode, Color outlineColour) {
        return new OutlinedHumanoidRenderer(outlineMode, outlineColour);
    }

    public static HumanoidRenderer coveredHumanoidRenderer(Color colour) {
        return new CoveredHumanoidRenderer(colour);
    }

    @Override
    public boolean canRender(Object o) {
        return o instanceof Humanoid;
    }

    private static class CoveredHumanoidRenderer
    extends HumanoidRenderer {
        private Color colour;

        CoveredHumanoidRenderer(Color colour) {
            this.colour = colour;
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) throws CannotFindLocationException {
            Humanoid h = (Humanoid)o;
            int[] xy = memory.getXY(h);
            if (xy == null) {
                return null;
            }
            int x = transform.toScreenX(xy[0]);
            int y = transform.toScreenY(xy[1]);
            RenderTools.setFillMode(g, 0, this.colour);
            g.fillOval(x - 5, y - 5, 11, 11);
            return new Ellipse2D.Double(x - 5, y - 5, 11.0, 11.0);
        }
    }

    private static class OutlinedHumanoidRenderer
    extends HumanoidRenderer {
        private int mode;
        private Color colour;

        OutlinedHumanoidRenderer(int mode, Color colour) {
            this.mode = mode;
            this.colour = colour;
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) throws CannotFindLocationException {
            Humanoid h = (Humanoid)o;
            int[] xy = memory.getXY(h);
            if (xy == null) {
                return null;
            }
            int x = transform.toScreenX(xy[0]);
            int y = transform.toScreenY(xy[1]);
            RenderTools.setLineMode(g, this.mode, this.colour);
            g.drawOval(x - 5, y - 5, 11, 11);
            return new Ellipse2D.Double(x - 5, y - 5, 11.0, 11.0);
        }
    }

    private static class OrdinaryHumanoidRenderer
    extends HumanoidRenderer {
        private OrdinaryHumanoidRenderer() {
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) throws CannotFindLocationException {
            Humanoid h = (Humanoid)o;
            int[] xy = memory.getXY(h);
            if (xy == null) {
                return null;
            }
            int x = transform.toScreenX(xy[0]);
            int y = transform.toScreenY(xy[1]);
            Color colour = ViewConstants.CIVILIAN_COLOUR;
            if (h.getType() == 66) {
                colour = ViewConstants.FIRE_BRIGADE_COLOUR;
            }
            if (h.getType() == 67) {
                colour = ViewConstants.AMBULANCE_TEAM_COLOUR;
            }
            if (h.getType() == 68) {
                colour = ViewConstants.POLICE_FORCE_COLOUR;
            }
            if (h.getType() == 65) {
                colour = ViewConstants.CAR_COLOUR;
            }
            RenderTools.setFillMode(g, 0, colour);
            g.fillOval(x - 5, y - 5, 11, 11);
            RenderTools.setLineMode(g, 0, Color.black);
            g.drawOval(x - 5, y - 5, 11, 11);
            return new Ellipse2D.Double(x - 5, y - 5, 11.0, 11.0);
        }
    }
}

