/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Line2D;
import rescuecore.Memory;
import rescuecore.view.Line;
import rescuecore.view.MapRenderer;
import rescuecore.view.ScreenTransform;

public class LineRenderer
implements MapRenderer {
    private Color colour;

    public LineRenderer(Color colour) {
        this.colour = colour;
    }

    @Override
    public boolean canRender(Object o) {
        return o instanceof Line;
    }

    @Override
    public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
        Line l = (Line)o;
        int x1 = transform.toScreenX(l.getX1());
        int y1 = transform.toScreenY(l.getY1());
        int x2 = transform.toScreenX(l.getX2());
        int y2 = transform.toScreenY(l.getY2());
        g.setColor(this.colour);
        g.drawLine(x1, y1, x2, y2);
        return new Line2D.Double(x1, y1, x2, y2);
    }
}

