/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import rescuecore2.config.Config;
import rescuecore2.config.ConfigException;

public final class CommandLineOptions {
    public static final String CONFIG_FLAG = "-c";
    public static final String HOST_FLAG = "-h";
    public static final String PORT_FLAG = "-p";

    private CommandLineOptions() {
    }

    public static String[] processArgs(String[] args, Config config) throws IOException, ConfigException {
        List<String> all = Arrays.asList(args);
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> it = all.iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (CONFIG_FLAG.equals(next)) {
                config.read(new File(it.next()));
                continue;
            }
            if (HOST_FLAG.equals(next)) {
                config.setValue("kernel.host", it.next());
                continue;
            }
            if (PORT_FLAG.equals(next)) {
                config.setValue("kernel.port", it.next());
                continue;
            }
            if (next.startsWith("--") && next.indexOf("=") != -1) {
                int index = next.indexOf("=");
                String key = next.substring(2, index);
                String value = next.substring(index + 1);
                config.setValue(key, value);
                continue;
            }
            result.add(next);
        }
        return result.toArray(new String[0]);
    }
}

