/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public class EntityRefListProperty
extends AbstractProperty {
    private List<EntityID> ids;

    public EntityRefListProperty(String urn) {
        super(urn);
        this.ids = new ArrayList<EntityID>();
    }

    public EntityRefListProperty(Enum<?> urn) {
        super(urn);
        this.ids = new ArrayList<EntityID>();
    }

    public EntityRefListProperty(String urn, List<EntityID> ids) {
        super(urn, true);
        this.ids = new ArrayList<EntityID>(ids);
    }

    public EntityRefListProperty(Enum<?> urn, List<EntityID> ids) {
        super(urn, true);
        this.ids = new ArrayList<EntityID>(ids);
    }

    public EntityRefListProperty(EntityRefListProperty other) {
        super(other);
        this.ids = new ArrayList<EntityID>(other.ids);
    }

    @Override
    public List<EntityID> getValue() {
        if (!this.isDefined()) {
            return null;
        }
        return Collections.unmodifiableList(this.ids);
    }

    public void setValue(List<EntityID> newIDs) {
        ArrayList<EntityID> old = new ArrayList<EntityID>(this.ids);
        this.ids.clear();
        this.ids.addAll(newIDs);
        this.setDefined();
        this.fireChange(old, Collections.unmodifiableList(this.ids));
    }

    public void addValue(EntityID id) {
        ArrayList<EntityID> old = new ArrayList<EntityID>(this.ids);
        this.ids.add(id);
        this.setDefined();
        this.fireChange(old, Collections.unmodifiableList(this.ids));
    }

    public void clearValues() {
        ArrayList<EntityID> old = new ArrayList<EntityID>(this.ids);
        this.ids.clear();
        this.fireChange(old, Collections.unmodifiableList(this.ids));
    }

    @Override
    public void takeValue(Property p) {
        if (p instanceof EntityRefListProperty) {
            EntityRefListProperty e = (EntityRefListProperty)p;
            if (e.isDefined()) {
                this.setValue((List<EntityID>)e.getValue());
            } else {
                this.undefine();
            }
        } else {
            throw new IllegalArgumentException(this + " cannot take value from " + p);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.ids.size(), out);
        for (EntityID next : this.ids) {
            EncodingTools.writeInt32(next.getValue(), out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        int count = EncodingTools.readInt32(in);
        ArrayList<EntityID> newIDs = new ArrayList<EntityID>(count);
        for (int i = 0; i < count; ++i) {
            newIDs.add(new EntityID(EncodingTools.readInt32(in)));
        }
        this.setValue(newIDs);
    }

    @Override
    public EntityRefListProperty copy() {
        return new EntityRefListProperty(this);
    }
}

