/*
 * Decompiled with CFR 0.152.
 */
package clear;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.standard.components.StandardSimulator;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.messages.AKClear;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public class ClearSimulator
extends StandardSimulator {
    private static final String SIMULATOR_NAME = "Area model clear simulator";
    private static final String REPAIR_RATE_KEY = "clear.repair.rate";
    private static final String REPAIR_DISTANCE_KEY = "clear.repair.distance";

    public String getName() {
        return SIMULATOR_NAME;
    }

    protected void processCommands(KSCommands c, ChangeSet changes) {
        long start = System.currentTimeMillis();
        int time = c.getTime();
        Logger.info((String)("Timestep " + time));
        HashMap<Blockade, Integer> partiallyCleared = new HashMap<Blockade, Integer>();
        HashSet<EntityID> cleared = new HashSet<EntityID>();
        for (Command command : c.getCommands()) {
            AKClear clear;
            if (!(command instanceof AKClear) || !this.isValid(clear = (AKClear)command, cleared)) continue;
            Logger.debug((String)("Processing " + clear));
            EntityID blockadeID = clear.getTarget();
            Blockade blockade = (Blockade)((StandardWorldModel)this.model).getEntity(blockadeID);
            Area area = (Area)((StandardWorldModel)this.model).getEntity(blockade.getPosition());
            int cost = blockade.getRepairCost();
            int rate = this.config.getIntValue(REPAIR_RATE_KEY);
            Logger.debug((String)("Blockade repair cost: " + cost));
            Logger.debug((String)("Blockade repair rate: " + rate));
            if (rate >= cost) {
                ArrayList ids = new ArrayList(area.getBlockades());
                ids.remove(blockadeID);
                area.setBlockades(ids);
                ((StandardWorldModel)this.model).removeEntity(blockadeID);
                changes.addChange((Entity)area, (Property)area.getBlockadesProperty());
                changes.entityDeleted(blockadeID);
                partiallyCleared.remove(blockade);
                cleared.add(blockadeID);
                Logger.debug((String)("Cleared " + blockade));
                continue;
            }
            if (!partiallyCleared.containsKey(blockade)) {
                partiallyCleared.put(blockade, cost);
            }
            blockade.setRepairCost(cost -= rate);
            changes.addChange((Entity)blockade, (Property)blockade.getRepairCostProperty());
        }
        for (Map.Entry entry : partiallyCleared.entrySet()) {
            Blockade b = (Blockade)entry.getKey();
            double original = ((Integer)entry.getValue()).intValue();
            double current = b.getRepairCost();
            double d = current / original;
            Logger.debug((String)("Partially cleared " + b));
            Logger.debug((String)("Original repair cost: " + original));
            Logger.debug((String)("New repair cost: " + current));
            Logger.debug((String)("Proportion left: " + d));
            int[] apexes = b.getApexes();
            double cx = b.getX();
            double cy = b.getY();
            for (int i = 0; i < apexes.length; i += 2) {
                double x = apexes[i];
                double y = apexes[i + 1];
                double dx = x - cx;
                double dy = y - cy;
                double newX = cx + dx * d;
                double newY = cy + dy * d;
                apexes[i] = (int)newX;
                apexes[i + 1] = (int)newY;
            }
            b.setApexes(apexes);
            changes.addChange((Entity)b, (Property)b.getApexesProperty());
        }
        long end = System.currentTimeMillis();
        Logger.info((String)("Timestep " + time + " took " + (end - start) + " ms"));
    }

    private boolean isValid(AKClear clear, Set<EntityID> cleared) {
        StandardEntity agent = (StandardEntity)((StandardWorldModel)this.model).getEntity(clear.getAgentID());
        StandardEntity target = (StandardEntity)((StandardWorldModel)this.model).getEntity(clear.getTarget());
        if (agent == null) {
            Logger.info((String)("Rejecting clear command " + clear + ": agent does not exist"));
            return false;
        }
        if (cleared.contains(clear.getTarget())) {
            Logger.info((String)("Ignoring clear command " + clear + ": target already cleared this timestep"));
            return false;
        }
        if (target == null) {
            Logger.info((String)("Rejecting clear command " + clear + ": target does not exist"));
            return false;
        }
        if (!(agent instanceof PoliceForce)) {
            Logger.info((String)("Rejecting clear command " + clear + ": agent is not a police officer"));
            return false;
        }
        if (!(target instanceof Blockade)) {
            Logger.info((String)("Rejecting clear command " + clear + ": target is not a road"));
            return false;
        }
        PoliceForce police = (PoliceForce)agent;
        StandardEntity agentPosition = police.getPosition(this.model);
        if (agentPosition == null) {
            Logger.info((String)("Rejecting clear command " + clear + ": could not locate agent"));
            return false;
        }
        if (!police.isHPDefined() || police.getHP() <= 0) {
            Logger.info((String)("Rejecting clear command " + clear + ": agent is dead"));
            return false;
        }
        if (police.isBuriednessDefined() && police.getBuriedness() > 0) {
            Logger.info((String)("Rejecting clear command " + clear + ": agent is buried"));
            return false;
        }
        Blockade targetBlockade = (Blockade)target;
        if (!targetBlockade.isPositionDefined()) {
            Logger.info((String)("Rejecting clear command " + clear + ": blockade has no position"));
            return false;
        }
        if (!targetBlockade.isRepairCostDefined()) {
            Logger.info((String)("Rejecting clear command " + clear + ": blockade has no repair cost"));
            return false;
        }
        int range = this.config.getIntValue(REPAIR_DISTANCE_KEY);
        Point2D agentLocation = new Point2D((double)police.getX(), (double)police.getY());
        double bestDistance = Double.MAX_VALUE;
        for (Line2D line : GeometryTools2D.pointsToLines((List)GeometryTools2D.vertexArrayToPoints((int[])targetBlockade.getApexes()), (boolean)true)) {
            Point2D closest = GeometryTools2D.getClosestPointOnSegment((Line2D)line, (Point2D)agentLocation);
            double distance = GeometryTools2D.getDistance((Point2D)agentLocation, (Point2D)closest);
            if (distance < (double)range) {
                return true;
            }
            if (!(bestDistance > distance)) continue;
            bestDistance = distance;
        }
        Logger.info((String)("Rejecting clear command " + clear + ": agent is not adjacent to target: distance is " + bestDistance));
        return false;
    }
}

