/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kernel.AgentProxy;
import kernel.CommandCollector;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.standard.messages.AKClear;
import rescuecore2.standard.messages.AKExtinguish;
import rescuecore2.standard.messages.AKLoad;
import rescuecore2.standard.messages.AKMove;
import rescuecore2.standard.messages.AKRescue;
import rescuecore2.standard.messages.AKRest;
import rescuecore2.standard.messages.AKUnload;

public class StandardCommandCollector
implements CommandCollector {
    private static final long WAIT_TIME = 100L;

    public void initialise(Config config) {
    }

    public Collection<Command> getAgentCommands(Collection<AgentProxy> agents, int timestep) throws InterruptedException {
        HashSet<AgentProxy> waiting = new HashSet<AgentProxy>(agents);
        while (!waiting.isEmpty()) {
            for (AgentProxy next : agents) {
                Collection commands = next.getAgentCommands(timestep);
                for (Command c : commands) {
                    if (!this.isTriggerCommand(c)) continue;
                    Logger.debug((String)(next + " sent a trigger command"));
                    waiting.remove(next);
                }
            }
            Logger.info((String)(this + " waiting for commands from " + waiting.size() + " agents"));
            Thread.sleep(100L);
        }
        ArrayList<Command> result = new ArrayList<Command>();
        for (AgentProxy next : agents) {
            result.addAll(next.getAgentCommands(timestep));
        }
        Logger.trace((String)(this + " returning " + result.size() + " commands"));
        return result;
    }

    public String toString() {
        return "Standard command collector";
    }

    private boolean isTriggerCommand(Command c) {
        return c instanceof AKMove || c instanceof AKRest || c instanceof AKExtinguish || c instanceof AKClear || c instanceof AKRescue || c instanceof AKLoad || c instanceof AKUnload;
    }
}

