/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import kernel.Kernel;
import kernel.KernelListenerAdapter;
import rescuecore2.GUIComponent;
import rescuecore2.Timestep;
import rescuecore2.standard.view.StandardWorldModelViewer;
import rescuecore2.view.EntityInspector;
import rescuecore2.view.RenderedObject;
import rescuecore2.view.ViewComponent;
import rescuecore2.view.ViewListener;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class StandardWorldModelViewerComponent
extends KernelListenerAdapter
implements GUIComponent {
    private static final int SIZE = 500;
    private StandardWorldModelViewer viewer = new StandardWorldModelViewer();
    private EntityInspector inspector = new EntityInspector();
    private JTextField field = new JTextField();
    private JComponent view;
    private WorldModel<? extends Entity> world;

    public StandardWorldModelViewerComponent() {
        this.viewer.setPreferredSize(new Dimension(500, 500));
        this.viewer.addViewListener(new ViewListener(){

            public void objectsClicked(ViewComponent v, List<RenderedObject> objects) {
                for (RenderedObject next : objects) {
                    if (!(next.getObject() instanceof Entity)) continue;
                    StandardWorldModelViewerComponent.this.inspector.inspect((Entity)next.getObject());
                    StandardWorldModelViewerComponent.this.field.setText("");
                    return;
                }
            }

            public void objectsRollover(ViewComponent v, List<RenderedObject> objects) {
            }
        });
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String s = StandardWorldModelViewerComponent.this.field.getText();
                try {
                    int id = Integer.parseInt(s);
                    EntityID eid = new EntityID(id);
                    Entity e = StandardWorldModelViewerComponent.this.world.getEntity(eid);
                    StandardWorldModelViewerComponent.this.inspector.inspect(e);
                }
                catch (NumberFormatException e) {
                    StandardWorldModelViewerComponent.this.field.setText("");
                }
            }
        });
        JSplitPane split = new JSplitPane(1, (Component)((Object)this.viewer), new JScrollPane((Component)this.inspector));
        this.view = new JPanel(new BorderLayout());
        this.view.add((Component)split, "Center");
        this.view.add((Component)this.field, "North");
    }

    public void simulationStarted(Kernel kernel) {
        this.viewer.initialise(kernel.getConfig());
        this.world = kernel.getWorldModel();
        this.viewer.view(new Object[]{this.world});
        this.viewer.repaint();
    }

    public void timestepCompleted(Kernel kernel, Timestep time) {
        this.viewer.view(new Object[]{kernel.getWorldModel(), time.getCommands(), time.getChangeSet()});
        this.viewer.repaint();
    }

    public JComponent getGUIComponent() {
        return this.view;
    }

    public String getGUIComponentName() {
        return "World view";
    }
}

