/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.rtree.RTree;

public class Node {
    int nodeId = 0;
    Rectangle mbr = null;
    Rectangle[] entries = null;
    int[] ids = null;
    int level;
    int entryCount;

    Node(int nodeId, int level, int maxNodeEntries) {
        this.nodeId = nodeId;
        this.level = level;
        this.entries = new Rectangle[maxNodeEntries];
        this.ids = new int[maxNodeEntries];
    }

    void addEntry(Rectangle r, int id) {
        this.ids[this.entryCount] = id;
        this.entries[this.entryCount] = r.copy();
        ++this.entryCount;
        if (this.mbr == null) {
            this.mbr = r.copy();
        } else {
            this.mbr.add(r);
        }
    }

    void addEntryNoCopy(Rectangle r, int id) {
        this.ids[this.entryCount] = id;
        this.entries[this.entryCount] = r;
        ++this.entryCount;
        if (this.mbr == null) {
            this.mbr = r.copy();
        } else {
            this.mbr.add(r);
        }
    }

    int findEntry(Rectangle r, int id) {
        for (int i = 0; i < this.entryCount; ++i) {
            if (id != this.ids[i] || !r.equals(this.entries[i])) continue;
            return i;
        }
        return -1;
    }

    void deleteEntry(int i, int minNodeEntries) {
        int lastIndex = this.entryCount - 1;
        Rectangle deletedRectangle = this.entries[i];
        this.entries[i] = null;
        if (i != lastIndex) {
            this.entries[i] = this.entries[lastIndex];
            this.ids[i] = this.ids[lastIndex];
            this.entries[lastIndex] = null;
        }
        --this.entryCount;
        if (this.entryCount >= minNodeEntries) {
            this.recalculateMBR(deletedRectangle);
        }
    }

    void recalculateMBR(Rectangle deletedRectangle) {
        if (this.mbr.edgeOverlaps(deletedRectangle)) {
            this.mbr.set(this.entries[0].min, this.entries[0].max);
            for (int i = 1; i < this.entryCount; ++i) {
                this.mbr.add(this.entries[i]);
            }
        }
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public Rectangle getEntry(int index) {
        if (index < this.entryCount) {
            return this.entries[index];
        }
        return null;
    }

    public int getId(int index) {
        if (index < this.entryCount) {
            return this.ids[index];
        }
        return -1;
    }

    void reorganize(RTree rtree) {
        int countdownIndex = rtree.maxNodeEntries - 1;
        for (int index = 0; index < this.entryCount; ++index) {
            if (this.entries[index] != null) continue;
            while (this.entries[countdownIndex] == null && countdownIndex > index) {
                --countdownIndex;
            }
            this.entries[index] = this.entries[countdownIndex];
            this.ids[index] = this.ids[countdownIndex];
            this.entries[countdownIndex] = null;
        }
    }

    boolean isLeaf() {
        return this.level == 1;
    }

    public int getLevel() {
        return this.level;
    }

    public Rectangle getMBR() {
        return this.mbr;
    }
}

