/*
 * Decompiled with CFR 0.152.
 */
package gis2;

import gis2.Scenario;
import gis2.ScenarioException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kernel.KernelException;
import kernel.WorldModelCreator;
import maps.CoordinateConversion;
import maps.MapException;
import maps.MapReader;
import maps.ScaleConversion;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLMap;
import maps.gml.GMLShape;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Edge;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class GMLWorldModelCreator
implements WorldModelCreator {
    private static final String MAP_DIRECTORY_KEY = "gis.map.dir";
    private static final String MAP_FILE_KEY = "gis.map.file";
    private static final String DEFAULT_MAP_FILE = "map.gml";
    private static final String SCENARIO_FILE_KEY = "gis.map.scenario";
    private static final String DEFAULT_SCENARIO_FILE = "scenario.xml";
    private static final double SQ_MM_TO_SQ_M = 1.0E-6;
    private int nextID;

    public String toString() {
        return "GML world model creator";
    }

    public WorldModel<? extends Entity> buildWorldModel(Config config) throws KernelException {
        try {
            StandardWorldModel result = new StandardWorldModel();
            File dir = new File(config.getValue(MAP_DIRECTORY_KEY));
            File mapFile = new File(dir, config.getValue(MAP_FILE_KEY, DEFAULT_MAP_FILE));
            File scenarioFile = new File(dir, config.getValue(SCENARIO_FILE_KEY, DEFAULT_SCENARIO_FILE));
            this.readMapData(mapFile, result);
            this.readScenarioData(scenarioFile, result, config);
            for (StandardEntity e : result) {
                this.nextID = Math.max(this.nextID, e.getID().getValue());
            }
            ++this.nextID;
            result.index();
            return result;
        }
        catch (MapException e) {
            throw new KernelException("Couldn't read GML file", (Throwable)e);
        }
        catch (DocumentException e) {
            throw new KernelException("Couldn't read scenario file", (Throwable)e);
        }
        catch (ScenarioException e) {
            throw new KernelException("Invalid scenario file", (Throwable)e);
        }
    }

    public EntityID generateID() {
        return new EntityID(this.nextID++);
    }

    private void readMapData(File mapFile, StandardWorldModel result) throws MapException {
        List<Point2D> vertices;
        EntityID id;
        GMLMap map = (GMLMap)MapReader.readMap((File)mapFile);
        CoordinateConversion conversion = this.getCoordinateConversion(map);
        Logger.debug((String)"Creating entities");
        Logger.debug((String)(map.getBuildings().size() + " buildings"));
        Logger.debug((String)(map.getRoads().size() + " roads"));
        for (GMLBuilding next : map.getBuildings()) {
            id = new EntityID(next.getID());
            Building b = new Building(id);
            vertices = this.convertShapeToPoints((GMLShape)next, conversion);
            double area = GeometryTools2D.computeArea(vertices) * 1.0E-6;
            Point2D centroid = GeometryTools2D.computeCentroid(vertices);
            b.setFloors(next.getFloors());
            b.setFieryness(0);
            b.setBrokenness(0);
            b.setBuildingCode(next.getCode());
            b.setBuildingAttributes(0);
            b.setGroundArea((int)Math.abs(area));
            b.setTotalArea((int)Math.abs(area) * b.getFloors());
            b.setImportance(next.getImportance());
            b.setEdges(this.createEdges((GMLShape)next, conversion));
            b.setX((int)centroid.getX());
            b.setY((int)centroid.getY());
            result.addEntity((Entity)b);
        }
        for (GMLBuilding next : map.getRoads()) {
            id = new EntityID(next.getID());
            Road r = new Road(id);
            vertices = this.convertShapeToPoints((GMLShape)next, conversion);
            Point2D centroid = GeometryTools2D.computeCentroid(vertices);
            r.setX((int)centroid.getX());
            r.setY((int)centroid.getY());
            r.setEdges(this.createEdges((GMLShape)next, conversion));
            result.addEntity((Entity)r);
        }
    }

    private void readScenarioData(File scenarioFile, StandardWorldModel result, Config config) throws DocumentException, ScenarioException {
        if (scenarioFile.exists()) {
            SAXReader reader = new SAXReader();
            Logger.debug((String)"Reading scenario");
            Document doc = reader.read(scenarioFile);
            Scenario scenario = new Scenario(doc);
            Logger.debug((String)"Applying scenario");
            scenario.apply(result, config);
        }
    }

    private List<Edge> createEdges(GMLShape s, CoordinateConversion conversion) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (GMLDirectedEdge edge : s.getEdges()) {
            GMLCoordinates start = edge.getStartCoordinates();
            GMLCoordinates end = edge.getEndCoordinates();
            Integer neighbourID = s.getNeighbour(edge);
            EntityID id = neighbourID == null ? null : new EntityID(neighbourID.intValue());
            double sx = conversion.convertX(start.getX());
            double sy = conversion.convertY(start.getY());
            double ex = conversion.convertX(end.getX());
            double ey = conversion.convertY(end.getY());
            result.add(new Edge((int)sx, (int)sy, (int)ex, (int)ey, id));
        }
        return result;
    }

    private List<Point2D> convertShapeToPoints(GMLShape shape, CoordinateConversion conversion) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (GMLCoordinates next : shape.getCoordinates()) {
            points.add(new Point2D(conversion.convertX(next.getX()), conversion.convertY(next.getY())));
        }
        return points;
    }

    private CoordinateConversion getCoordinateConversion(GMLMap map) {
        return new ScaleConversion(map.getMinX(), map.getMinY(), 1000.0, 1000.0);
    }
}

