/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLShape;

public class PlaceAmbulanceTeamTool
extends ShapeTool {
    public PlaceAmbulanceTeamTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place ambulance team";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return true;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addAmbulanceTeam(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddAmbulanceTeamEdit(shape.getID()));
    }

    private class AddAmbulanceTeamEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddAmbulanceTeamEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlaceAmbulanceTeamTool.this.editor.getScenario().removeAmbulanceTeam(this.id);
            PlaceAmbulanceTeamTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlaceAmbulanceTeamTool.this.editor.getScenario().addAmbulanceTeam(this.id);
            PlaceAmbulanceTeamTool.this.editor.updateOverlays();
        }
    }
}

