/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLShape;

public class PlacePoliceForceTool
extends ShapeTool {
    public PlacePoliceForceTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place police force";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return true;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addPoliceForce(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddPoliceForceEdit(shape.getID()));
    }

    private class AddPoliceForceEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddPoliceForceEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlacePoliceForceTool.this.editor.getScenario().removePoliceForce(this.id);
            PlacePoliceForceTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlacePoliceForceTool.this.editor.getScenario().addPoliceForce(this.id);
            PlacePoliceForceTool.this.editor.updateOverlays();
        }
    }
}

