/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLShape;

public class RemoveCivilianTool
extends ShapeTool {
    public RemoveCivilianTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove civilian";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return true;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removeCivilian(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemoveCivilianEdit(shape.getID()));
    }

    private class RemoveCivilianEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemoveCivilianEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemoveCivilianTool.this.editor.getScenario().addCivilian(this.id);
            RemoveCivilianTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemoveCivilianTool.this.editor.getScenario().removeCivilian(this.id);
            RemoveCivilianTool.this.editor.updateOverlays();
        }
    }
}

