/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class RemoveFireStationTool
extends ShapeTool {
    public RemoveFireStationTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove fire station";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removeFireStation(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemoveFireStationEdit(shape.getID()));
    }

    private class RemoveFireStationEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemoveFireStationEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemoveFireStationTool.this.editor.getScenario().addFireStation(this.id);
            RemoveFireStationTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemoveFireStationTool.this.editor.getScenario().removeFireStation(this.id);
            RemoveFireStationTool.this.editor.updateOverlays();
        }
    }
}

