/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class RemoveFireTool
extends ShapeTool {
    public RemoveFireTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove fire";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removeFire(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemoveFireEdit(shape.getID()));
    }

    private class RemoveFireEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemoveFireEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemoveFireTool.this.editor.getScenario().addFire(this.id);
            RemoveFireTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemoveFireTool.this.editor.getScenario().removeFire(this.id);
            RemoveFireTool.this.editor.updateOverlays();
        }
    }
}

