/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import org.util.xml.parse.policy.ParserPolicy;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.util.xml.element.Attributes;
import org.util.xml.element.Element;
import org.util.xml.element.TagElement;
import org.util.xml.element.TextElement;
import org.util.xml.parse.policy.*;
import org.util.xml.parse.XMLParseException;


/**
 *
 * @author masaru
 */
public class ElementParser {

    private Reader reader_;
    protected static ElementPartParser element_part_parser_;
    private Element[] result_;
    private ParserPolicy policy_;
    private int tab_count_;
    private String encoding_ = "unknown";
    private boolean select_encoding_after_readeing_first_line_;
    private InputStream is_;
    private ElementParser data_source_;
    private URI document_base_;
    private ArrayList<ParserPolicy> policy_stack_ = new ArrayList<ParserPolicy>();
    
    protected ElementParser(){}
    public ElementParser(Reader reader) {
        init(reader);
    }
    public ElementParser(InputStream is) {
        init(is);
    }
    public ElementParser(InputStream is, String encoding) throws UnsupportedEncodingException {
        init(new InputStreamReader(is,encoding));
    }
    public void setDocumentBase(URI document_base) {
        document_base_ = document_base;
    }
    public URI getDocumentBase() {
    	return document_base_;
    }
    public Element[] createSubElements(String sub_path) throws Exception {
        ElementParser sub_parser = createSubParser(sub_path);
        sub_parser.parse();
        return sub_parser.getResult();
        
    }
    public ElementParser createSubParser(String sub_path) throws Exception {
        URI uri = null;
        if(document_base_ != null)
            uri = document_base_.resolve(sub_path);
        else {
            uri = new File(sub_path).toURI();
        }
        ElementParser sub_parser = new ElementParser(uri.toURL().openStream());
        sub_parser.setDocumentBase(uri.resolve(".."));
        sub_parser.setPolicy(policy_);
        return sub_parser;
    }
    
    private void initParsers() {
        if(policy_==null) {
            policy_ = new DefaultParserPolicy() {
                String encoding_;
                public boolean forceEmptyTag(String key) {
                    return false;
                   }
                public Element allowElement(Element element) {
                    if(encoding_ == null) {
                        if(element.isTagElement()){
                            TagElement te = (TagElement)element;
                            if(te.isPI())
                                encoding_ = te.getAttributeValue("encoding");
                        }
                        if(encoding_ == null) encoding_ = "utf-8";
                    }
                    return element;
                }

                public String selectEncoding(String last_tag_key) {
                    return encoding_;
                }
            };
        }
        element_part_parser_ = new ElementPartParser(policy_);
    }
    
    public void setPolicy(ParserPolicy policy) {
        policy_ = policy;
        initParsers();
    }

    private void init(InputStream is) {
        initParsers();
        select_encoding_after_readeing_first_line_ = true;
        is_ = is;
    }
    private void init(Reader reader){
        initParsers();
        if(reader instanceof InputStreamReader){
            encoding_ = ((InputStreamReader)reader).getEncoding();
            reader_ = new BufferedReader(reader);
        }else
            reader_ = reader;
    }
    
    public void error(ParseElement source) {
        
        System.err.println("error: ");
        System.err.println(source);
        try{
            for(int i=0;i<1000;i++) {
                System.err.print((char)get());
            }
        }catch(Exception e) {}
    }
    


    public Element[] parse() throws IOException, XMLParseException {
        tab_count_ = 0;
	
        ArrayList<Element> list = new ArrayList<Element>();
        
        if (reader_ != null) {
            data_source_ = this;
        }
        else {
            data_source_ = new ElementParser() {
		    public int get() throws IOException {
                        return is_.read();
                    }
		};
        }
        element_part_parser_.error_text_ = new StringBuffer();
        
	try {
            int last = parse(data_source_.get(), list);
	}
        catch(XMLParseException e){
	    if(e.getMessage().equals("$cancel"))
		System.out.println("parse canelled");
	    else
		throw e;
        }
        catch(IOException e){
	    if(e.getMessage().equals("$cancel"))
		System.out.println("parse canelled");
	    else
		throw e;
	}
        /*if( last == -1)
	  System.out.println("end of stream.(ok)");
	  else
	  System.out.println("! Not end of stream !");*/
        
        result_ = list.toArray(new Element[]{});
        
        //for(int i=0;i<list.size();i++)
	//  System.out.println(list.get(i).toString());
        return result_;
    }
    
    private int parse(int next, ArrayList<Element> list) throws XMLParseException, IOException {
	
        Element element = null;
        
        while(next>=0) {
	    
            next = element_part_parser_.parse(next, data_source_);
	    
            if(element_part_parser_.is_error_ && policy_.throwExceptionIfDocumentHasError())
                throw new XMLParseException(element_part_parser_.error_text_.toString());
            
            if(element_part_parser_.isTextElement()) {
                TextElement text_element = element_part_parser_.getTextElement();
                element = policy_.allowElement(text_element);
		
            } else if(element_part_parser_.isTagElement()){
                
                TagElement tag_element = element_part_parser_.getTagElement();
		//System.out.println(tag_element);
		//JOptionPane.showMessageDialog(null, tag_element.getKey());
                
                if(reader_ == null) {
                    String encoding = policy_.selectEncoding(tag_element.getKey());
                    if(encoding != null) {
			//System.out.println("set encoding: "+encoding);
                        encoding_ = encoding;
                        try {
                        reader_ = new BufferedReader(new InputStreamReader(is_, encoding));
                        }
                        catch(UnsupportedEncodingException exc) {
                            throw new XMLParseException(exc.toString());
                        }
                        data_source_ = this;
                    }
                }
                
		//System.out.println("\nkey: "+tag_element.getKey());
		//System.out.println("att: "+tag_element.getAttributes());
		
                if(element_part_parser_.isStartTag()){
		    //JOptionPane.showMessageDialog(null, "start tag:\n");
		    policy_stack_.add(policy_);
                    policy_ = policy_.getInnerPolicy(tag_element);
		    
                    tab_count_++;
                    String start_key = tag_element.getKey();
		    //System.out.println("start tag: "+start_key);
                    
                    ArrayList<Element> children = new ArrayList<Element>();
                    next = parse(next, children);
		    
                    String end_key = element_part_parser_.getEndTagName();
                    if(policy_.checkEndTag())
                        if(!start_key.equals(end_key) && policy_.throwExceptionIfDocumentHasError()) {
                            String message = "end tag does not match! (start:"+start_key+" end:"+end_key+")";
                            if(element_part_parser_.is_error_)
                                element_part_parser_.error_text_.append(message);
                            else
                                throw new XMLParseException(message);
                        }
		    //                        throw new Exception("parse error: "+end_key+" does not match "+start_key);
                    
                    tag_element.setChildren(children.toArray(new Element[]{}));
                    tab_count_--;
		    //System.out.println("end children :"+tag_element.getKey());
		    if(policy_stack_.size()>0)
			policy_ = policy_stack_.remove(policy_stack_.size()-1);
                }
                
		//JOptionPane.showMessageDialog(null, "add to list:\n"+tag_element.getKey());
		tag_element.setDocumentBase(getDocumentBase());
		
                element = policy_.allowElement(tag_element);
		
                //System.out.println("add-----------------------");
            } else { // end tag
                if(!policy_.forceEmptyTag(element_part_parser_.getEndTagName()))
                    return next;
                element = null;
            }
            
            if(element != null) list.add(element);
	    
	    next = element_part_parser_.parse(next, data_source_);
	    
	    if(element_part_parser_.is_error_ && policy_.throwExceptionIfDocumentHasError())
		throw new XMLParseException(element_part_parser_.error_text_.toString());
	    
	    if(element_part_parser_.isTextElement()) {
		TextElement text_element = element_part_parser_.getTextElement();
		element = policy_.allowElement(text_element);
		
	    } else if(element_part_parser_.isTagElement()){
		
		TagElement tag_element = element_part_parser_.getTagElement();
		//System.out.println(tag_element);
		//JOptionPane.showMessageDialog(null, tag_element.getKey());
		
		if(reader_ == null) {
		    String encoding = policy_.selectEncoding(tag_element.getKey());
		    if(encoding != null) {
			//System.out.println("set encoding: "+encoding);
			encoding_ = encoding;
                        try {
                            reader_ = new BufferedReader(new InputStreamReader(is_, encoding));
                        }
                        catch(UnsupportedEncodingException exc) {
                            throw new XMLParseException(exc.toString());
                        }
			data_source_ = this;
		    }
		}
		
		//System.out.println("\nkey: "+tag_element.getKey());
		//System.out.println("att: "+tag_element.getAttributes());
		
		if(element_part_parser_.isStartTag()){
		    //JOptionPane.showMessageDialog(null, "start tag:\n");
		    policy_stack_.add(policy_);
		    policy_ = policy_.getInnerPolicy(tag_element);
		    if(policy_.finished())
			throw new XMLParseException("$cancel");	
	    
		    tab_count_++;
		    String start_key = tag_element.getKey();
		    //System.out.println("start tag: "+start_key);
		    
		    ArrayList<Element> children = new ArrayList<Element>();
		    next = parse(next, children);
		    
		    String end_key = element_part_parser_.getEndTagName();
		    if(policy_.checkEndTag())
			if(!start_key.equals(end_key) && policy_.throwExceptionIfDocumentHasError()) {
			    String message = "end tag does not match! (start:"+start_key+" end:"+end_key+")";
			    if(element_part_parser_.is_error_)
				element_part_parser_.error_text_.append(message);
			    else
				throw new XMLParseException(message);
			}
		    //                        throw new Exception("parse error: "+end_key+" does not match "+start_key);
		    
		    tag_element.setChildren(children.toArray(new Element[]{}));
		    tab_count_--;
		    //System.out.println("end children :"+tag_element.getKey());
		    if(policy_stack_.size()>0)
			policy_ = policy_stack_.remove(policy_stack_.size()-1);

		    if(policy_.finished())
			throw new XMLParseException("$cancel");
		}
		
		//JOptionPane.showMessageDialog(null, "add to list:\n"+tag_element.getKey());
		tag_element.setDocumentBase(getDocumentBase());
		
		element = policy_.allowElement(tag_element);
		
		//System.out.println("add-----------------------");
	    } else { // end tag
		if(!policy_.forceEmptyTag(element_part_parser_.getEndTagName()))
		    return next;
		element = null;
	    }
	    
	    if(element != null) list.add(element);
	    
	    if(policy_.finished())
		throw new XMLParseException("$cancel");
	}
	return -1;
    }
    

    public int escape (String message) throws XMLParseException, IOException {
        int next = -1;
        try { throw new Exception("mark");}catch(Exception e){e.printStackTrace();}
        System.err.println("this documents has error: "+message);
        System.err.println("skip---------------------");
        int c = get();
        System.err.print((char)c);
        while(c!='>' && c!=-1) System.err.print((char)(c=get()));
        //        for(int i=0;i<3000;i++) System.err.print((char)(c=parser.get()));
        System.err.println("\n-------------------------");
        return get();
    }
    
    public Element[] getResult() {
        return result_;
    }
    public TagElement getFirstPlainTagElement() {
        for(Element tmp : result_)
            if(tmp.isTagElement()) {
                TagElement tag = (TagElement)tmp;
                if(!tag.isPI())
                    return tag;
            }
        return null;
    }
    
    public String getEncoding() {
        return encoding_;
    }
    
    int counter = 0;
    long start = System.currentTimeMillis();
    public int get() throws IOException {
        return reader_.read();

//        int val = reader_.read();
//        counter++;
//System.out.print("["+(char)val+"]");
//        return val;
    }
    public char getChar() throws IOException {
        int b = get();
        if(b==-1) throw new IOException("end of stream.");
        return (char)b;
    }
}
