package org.util.env;

import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class LaunchInformation {
    
    private static boolean initialized_;
    private static boolean jar_mode_;
    private static URL jar_base_url_;
    private static URL jar_parent_url_;
    

    public static void init() {
	if(initialized_) return ;

    	URL launch_information_class_url = ClassLoader.getSystemClassLoader().getResource("org/util/env/LaunchInformation.class");
	jar_mode_ = (launch_information_class_url.getProtocol().toLowerCase().equals("jar"));

	if(jar_mode_) {
	    String licu_text = launch_information_class_url.toString();
	    try{
		jar_base_url_ = new URL(licu_text.substring(0, licu_text.indexOf("!")+2));
		jar_parent_url_ = new URL(licu_text.substring(4, licu_text.indexOf("!")));
	    }catch(Exception e){
		e.printStackTrace();
	    }
	    System.out.println(jar_base_url_);
	}
	initialized_ = true;
    }

    public static boolean isJarMode() {
	init();
	return jar_mode_;
    }
    public static URL getJarParentURL() {
	init();
	return jar_parent_url_;
    }
    public static URL getJarBaseURL() {
	init();
	return jar_base_url_;
    }
    public static URL createJarURL(String path) throws Exception {
	init();
	return new URL(jar_base_url_, path);
    }
    public static URL createJarParentURL(String path) throws Exception {
	init();
	return new URL(jar_parent_url_, path);
    }
    
}