//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CSFileStream.cs
 * @brief		FileStream t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2013-2014 Takazumi Shirayanagi\n
 * This software is released under the MIT License,
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// using
using System;
using System.IO;
using System.Text;
using System.Security.AccessControl;
using Microsoft.Win32.SafeHandles;

namespace Common
{
	/// <summary>
	/// FileStream NX
	/// </summary>
	class CSFileStream : IDisposable
	{
		#region tB[h
		private FileStream m_Stream = null;	//!< t@CXg[
		#endregion

		#region RXgN^
		public CSFileStream() { }
		public CSFileStream(SafeFileHandle handle, FileAccess access) { Open(handle, access); }
		public CSFileStream(string path, FileMode mode) { Open(path, mode); }
		public CSFileStream(SafeFileHandle handle, FileAccess access, int bufferSize) { Open(handle, access, bufferSize); }
		public CSFileStream(string path, FileMode mode, FileAccess access) { Open(path, mode, access); }
		public CSFileStream(SafeFileHandle handle, FileAccess access, int bufferSize, bool isAsync) { Open(handle, access, bufferSize, isAsync); }
		public CSFileStream(string path, FileMode mode, FileAccess access, FileShare share) { Open(path, mode, access, share); }
		public CSFileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize) { Open(path, mode, access, share, bufferSize); }
		public CSFileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, bool isAsync) { Open(path, mode, access, share, bufferSize, isAsync); }
		public CSFileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, FileOptions options) { Open(path, mode, access, share, bufferSize, options); }
		public CSFileStream(string path, FileMode mode, FileSystemRights rights, FileShare share, int bufferSize, FileOptions options) { Open(path, mode, rights, share, bufferSize, options); }
		public CSFileStream(string path, FileMode mode, FileSystemRights rights, FileShare share, int bufferSize, FileOptions options, FileSecurity fileSecurity) { Open(path, mode, rights, share, bufferSize, options, fileSecurity); }
		#endregion

		#region fXgN^
		~CSFileStream() { Close(); Dispose(); }
		#endregion

		#region Dispose
		public void Dispose()
		{
			if (m_Stream != null)
			{
				m_Stream.Dispose();
				m_Stream = null;
			}
		}
		#endregion

		#region Open
		public bool Open(SafeFileHandle handle, FileAccess access) 
		{
			try
			{
				m_Stream = new FileStream(handle, access);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(string path, FileMode mode)
		{
			try
			{
				m_Stream = new FileStream(path, mode);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(SafeFileHandle handle, FileAccess access, int bufferSize)
		{
			try
			{
				m_Stream = new FileStream(handle, access, bufferSize);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(string path, FileMode mode, FileAccess access)
		{
			try
			{
				m_Stream = new FileStream(path, mode, access);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(SafeFileHandle handle, FileAccess access, int bufferSize, bool isAsync)
		{
			try
			{
				m_Stream = new FileStream(handle, access, bufferSize, isAsync);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(string path, FileMode mode, FileAccess access, FileShare share)
		{
			try
			{
				m_Stream = new FileStream(path, mode, access, share);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize)
		{
			try
			{
				m_Stream = new FileStream(path, mode, access, share, bufferSize);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, bool isAsync)
		{
			try
			{
				m_Stream = new FileStream(path, mode, access, share, bufferSize, isAsync);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, FileOptions options)
		{
			try
			{
				m_Stream = new FileStream(path, mode, access, share, bufferSize, options);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(string path, FileMode mode, FileSystemRights rights, FileShare share, int bufferSize, FileOptions options)
		{
			try
			{
				m_Stream = new FileStream(path, mode, rights, share, bufferSize, options);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		public bool Open(string path, FileMode mode, FileSystemRights rights, FileShare share, int bufferSize, FileOptions options, FileSecurity fileSecurity)
		{
			try
			{
				m_Stream = new FileStream(path, mode, rights, share, bufferSize, options, fileSecurity);
			}
			catch (Exception e)
			{
				CSConsole.Write(e.ToString());
				return false;
			}
			return true;
		}
		#endregion

		#region Close
		public void Close()
		{
			if (m_Stream != null)
				m_Stream.Close();
		}
		#endregion

		#region Write
		public void Write(byte[] array, int offset, int count)
		{
			m_Stream.Write(array, offset, count);
		}
		public void Write(string str, int offset)
		{
			byte[] buf = Encoding.Default.GetBytes(str);
			m_Stream.Write(buf, offset, buf.Length);
		}
		#endregion

		#region Read
		public void Read(byte[] array, int offset, int count)
		{
			m_Stream.Read(array, offset, count);
		}
		public void Read(string str, int offset, int count)
		{
			byte[] array = new byte[count];
			m_Stream.Read(array, offset, count);
			str = Encoding.Default.GetString(array, 0, count);
		}
		#endregion

		#region vpeB

		#region FileStream
		public FileStream Stream
		{
			get { return m_Stream; }
		}
		#endregion

		#endregion
	}
}	// end of namespace Common

