﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXAPIWindows.cs
 * @brief		Win32 API ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2013-2014 Takazumi Shirayanagi\n
 * This software is released under the MIT License,
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// using
using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace win32
{
	public partial class API
	{
		#region GWL
		[Flags]
		public enum GWL : int
		{
			GWL_WNDPROC		= -4,
			GWL_HINSTANCE	= -6,
			GWL_HWNDPARENT	= -8,
			GWL_STYLE		= -16,
			GWL_EXSTYLE		= -20,
			GWL_USERDATA	= -21,
			GWL_ID			= -12
		}
		#endregion

		#region WS
		[Flags]
		public enum WS : long
		{
			WS_OVERLAPPED	=	0x00000000L,
			WS_POPUP		=	0x80000000L,
			WS_CHILD		=	0x40000000L,
			WS_MINIMIZE		=	0x20000000L,
			WS_VISIBLE		=	0x10000000L,
			WS_DISABLED		=	0x08000000L,
			WS_CLIPSIBLINGS	=	0x04000000L,
			WS_CLIPCHILDREN	=	0x02000000L,
			WS_MAXIMIZE		=	0x01000000L,
			WS_CAPTION		=	0x00C00000L,		/* WS_BORDER | WS_DLGFRAME	*/
			WS_BORDER		=	0x00800000L,
			WS_DLGFRAME		=	0x00400000L,
			WS_VSCROLL		=	0x00200000L,
			WS_HSCROLL		=	0x00100000L,
			WS_SYSMENU		=	0x00080000L,
			WS_THICKFRAME	=	0x00040000L,
			WS_GROUP		=	0x00020000L,
			WS_TABSTOP		=	0x00010000L,

			WS_MINIMIZEBOX	=	0x00020000L,
			WS_MAXIMIZEBOX	=	0x00010000L,

			WS_OVERLAPPEDWINDOW	= (	WS_OVERLAPPED	   |
									WS_CAPTION		   |
									WS_SYSMENU		   |
									WS_THICKFRAME	   |
									WS_MINIMIZEBOX	   |
									WS_MAXIMIZEBOX),

			WS_POPUPWINDOW	=	(	WS_POPUP		   |
									WS_BORDER		   |
									WS_SYSMENU),

			WS_CHILDWINDOW	=	WS_CHILD,


			WS_TILED		=	WS_OVERLAPPED,
			WS_ICONIC		=	WS_MINIMIZE,
			WS_SIZEBOX		=	WS_THICKFRAME,
			WS_TILEDWINDOW	=	WS_OVERLAPPEDWINDOW,

			MASK			= 0xFFFF0000L,
		}
		#endregion

		#region WSEX
		public enum WSEX : long
		{
			WS_EX_DLGMODALFRAME		= 0x00000001L,
			WS_EX_NOPARENTNOTIFY	= 0x00000004L,
			WS_EX_TOPMOST			= 0x00000008L,
			WS_EX_ACCEPTFILES		= 0x00000010L,
			WS_EX_TRANSPARENT		= 0x00000020L,
			WS_EX_MDICHILD			= 0x00000040L,
			WS_EX_TOOLWINDOW		= 0x00000080L,
			WS_EX_WINDOWEDGE		= 0x00000100L,
			WS_EX_CLIENTEDGE		= 0x00000200L,
			WS_EX_CONTEXTHELP		= 0x00000400L,

			WS_EX_RIGHT				= 0x00001000L,
			WS_EX_LEFT				= 0x00000000L,
			WS_EX_RTLREADING		= 0x00002000L,
			WS_EX_LTRREADING		= 0x00000000L,
			WS_EX_LEFTSCROLLBAR		= 0x00004000L,
			WS_EX_RIGHTSCROLLBAR	= 0x00000000L,

			WS_EX_CONTROLPARENT		= 0x00010000L,
			WS_EX_STATICEDGE		= 0x00020000L,
			WS_EX_APPWINDOW			= 0x00040000L,

			WS_EX_OVERLAPPEDWINDOW	= (WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE),
			WS_EX_PALETTEWINDOW		= (WS_EX_WINDOWEDGE | WS_EX_TOOLWINDOW | WS_EX_TOPMOST),

			WS_EX_LAYERED			= 0x00080000L,

			WS_EX_NOINHERITLAYOUT	= 0x00100000L, // Disable inheritence of mirroring by children
			WS_EX_LAYOUTRTL			= 0x00400000L, // Right to left mirroring

			WS_EX_COMPOSITED		= 0x02000000L,
			WS_EX_NOACTIVATE		= 0x08000000L,
		}
		#endregion

		#region DS
		[Flags]
		public enum DS : long
		{
			DS_ABSALIGN			= 0x0001L,
			DS_SYSMODAL			= 0x0002L,
			DS_LOCALEDIT		= 0x0020L,	/* Edit items get Local storage. */
			DS_SETFONT			= 0x0040L,	/* User specified font for Dlg controls */
			DS_MODALFRAME		= 0x0080L,	/* Can be combined with WS_CAPTION	*/
			DS_NOIDLEMSG		= 0x0100L,	/* WM_ENTERIDLE message will not be sent */
			DS_SETFOREGROUND	= 0x0200L,	/* not in win3.1 */
			DS_3DLOOK			= 0x0004L,
			DS_FIXEDSYS			= 0x0008L,
			DS_NOFAILCREATE		= 0x0010L,
			DS_CONTROL			= 0x0400L,
			DS_CENTER			= 0x0800L,
			DS_CENTERMOUSE		= 0x1000L,
			DS_CONTEXTHELP		= 0x2000L,

			DS_SHELLFONT		= (DS_SETFONT | DS_FIXEDSYS),

			DS_USEPIXELS		= 0x8000L,
			
			MASK				= 0xFFFFL,
		}
		#endregion

		#region ES
		[Flags]
		public enum ES : long
		{
			ES_LEFT				= 0x0000L,
			ES_CENTER			= 0x0001L,
			ES_RIGHT			= 0x0002L,
			ES_MULTILINE		= 0x0004L,
			ES_UPPERCASE		= 0x0008L,
			ES_LOWERCASE		= 0x0010L,
			ES_PASSWORD			= 0x0020L,
			ES_AUTOVSCROLL		= 0x0040L,
			ES_AUTOHSCROLL		= 0x0080L,
			ES_NOHIDESEL		= 0x0100L,
			ES_OEMCONVERT		= 0x0400L,
			ES_READONLY			= 0x0800L,
			ES_WANTRETURN		= 0x1000L,
			ES_NUMBER			= 0x2000L,
			MASK				= 0xFFFFL,
		}
		#endregion

		#region BS
		public enum BS : long
		{
			BS_PUSHBUTTON		= 0x00000000L,
			BS_DEFPUSHBUTTON	= 0x00000001L,
			BS_CHECKBOX			= 0x00000002L,
			BS_AUTOCHECKBOX		= 0x00000003L,
			BS_RADIOBUTTON		= 0x00000004L,
			BS_3STATE			= 0x00000005L,
			BS_AUTO3STATE		= 0x00000006L,
			BS_GROUPBOX			= 0x00000007L,
			BS_USERBUTTON		= 0x00000008L,
			BS_AUTORADIOBUTTON	= 0x00000009L,
			BS_PUSHBOX			= 0x0000000AL,
			BS_OWNERDRAW		= 0x0000000BL,
			BS_TYPEMASK			= 0x0000000FL,
			BS_LEFTTEXT			= 0x00000020L,

			BS_TEXT				= 0x00000000L,
			BS_ICON				= 0x00000040L,
			BS_BITMAP			= 0x00000080L,
			BS_LEFT				= 0x00000100L,
			BS_RIGHT			= 0x00000200L,
			BS_CENTER			= 0x00000300L,
			BS_TOP				= 0x00000400L,
			BS_BOTTOM			= 0x00000800L,
			BS_VCENTER			= 0x00000C00L,
			BS_PUSHLIKE			= 0x00001000L,
			BS_MULTILINE		= 0x00002000L,
			BS_NOTIFY			= 0x00004000L,
			BS_FLAT				= 0x00008000L,
			BS_RIGHTBUTTON		= BS_LEFTTEXT,
			
			MASK				= 0x0000FFFFL,
		}
		#endregion

		#region CBS
		[Flags]
		public enum CBS : long
		{
			CBS_SIMPLE				= 0x0001L,
			CBS_DROPDOWN			= 0x0002L,
			CBS_DROPDOWNLIST		= 0x0003L,
			CBS_OWNERDRAWFIXED		= 0x0010L,
			CBS_OWNERDRAWVARIABLE	= 0x0020L,
			CBS_AUTOHSCROLL			= 0x0040L,
			CBS_OEMCONVERT			= 0x0080L,
			CBS_SORT				= 0x0100L,
			CBS_HASSTRINGS			= 0x0200L,
			CBS_NOINTEGRALHEIGHT	= 0x0400L,
			CBS_DISABLENOSCROLL		= 0x0800L,

			CBS_UPPERCASE			= 0x2000L,
			CBS_LOWERCASE			= 0x4000L,
			
			MASK					= 0xFFFFL,
		}
		#endregion

		#region SBS
		[Flags]
		public enum SBS : long
		{
			SBS_HORZ					= 0x0000L,
			SBS_VERT					= 0x0001L,
			SBS_TOPALIGN				= 0x0002L,
			SBS_LEFTALIGN				= 0x0002L,
			SBS_BOTTOMALIGN				= 0x0004L,
			SBS_RIGHTALIGN				= 0x0004L,
			SBS_SIZEBOXTOPLEFTALIGN		= 0x0002L,
			SBS_SIZEBOXBOTTOMRIGHTALIGN	= 0x0004L,
			SBS_SIZEBOX					= 0x0008L,
			SBS_SIZEGRIP				= 0x0010L,
			
			MASK						= 0xFFFFL,
		}
		#endregion

		#region PBS
		[Flags]
		public enum PBS : long
		{
			PBS_SMOOTH			= 0x01,
			PBS_VERTICAL		= 0x04,
			PBS_MARQUEE			= 0x08,

			MASK				= 0x0F,
		}
		#endregion

		#region TCS
		[Flags]
		public enum TCS : long
		{
			TCS_SCROLLOPPOSITE		= 0x0001L,	 // assumes multiline tab
			TCS_BOTTOM				= 0x0002L,
			TCS_RIGHT				= 0x0002L,
			TCS_MULTISELECT			= 0x0004L,	// allow multi-select in button mode

			TCS_FLATBUTTONS			= 0x0008L,

			TCS_FORCEICONLEFT		= 0x0010L,
			TCS_FORCELABELLEFT		= 0x0020L,

			TCS_HOTTRACK			= 0x0040L,
			TCS_VERTICAL			= 0x0080L,

			TCS_TABS				= 0x0000L,
			TCS_BUTTONS				= 0x0100L,
			TCS_SINGLELINE			= 0x0000L,
			TCS_MULTILINE			= 0x0200L,
			TCS_RIGHTJUSTIFY		= 0x0000L,
			TCS_FIXEDWIDTH			= 0x0400L,
			TCS_RAGGEDRIGHT			= 0x0800L,
			TCS_FOCUSONBUTTONDOWN	= 0x1000L,
			TCS_OWNERDRAWFIXED		= 0x2000L,
			TCS_TOOLTIPS			= 0x4000L,
			TCS_FOCUSNEVER			= 0x8000L,
			
			MASK					= 0xFFFFL,
		}
		#endregion

		#region LBS
		[Flags]
		public enum LBS : long
		{
			LBS_NOTIFY				= 0x0001L,
			LBS_SORT				= 0x0002L,
			LBS_NOREDRAW			= 0x0004L,
			LBS_MULTIPLESEL			= 0x0008L,
			LBS_OWNERDRAWFIXED		= 0x0010L,
			LBS_OWNERDRAWVARIABLE	= 0x0020L,
			LBS_HASSTRINGS			= 0x0040L,
			LBS_USETABSTOPS			= 0x0080L,
			LBS_NOINTEGRALHEIGHT	= 0x0100L,
			LBS_MULTICOLUMN			= 0x0200L,
			LBS_WANTKEYBOARDINPUT	= 0x0400L,
			LBS_EXTENDEDSEL			= 0x0800L,
			LBS_DISABLENOSCROLL		= 0x1000L,
			LBS_NODATA				= 0x2000L,

			LBS_NOSEL				= 0x4000L,

			LBS_COMBOBOX			= 0x8000L,

			LBS_STANDARD			= (LBS_NOTIFY | LBS_SORT | API.WS.WS_VSCROLL | API.WS.WS_BORDER),

			MASK					= (0xFFFFL | API.WS.WS_VSCROLL | API.WS.WS_BORDER),
		}
		#endregion

		#region LVS
		[Flags]
		public enum LVS : long
		{
			LVS_ICON				= 0x0000L,
			LVS_REPORT				= 0x0001L,
			LVS_SMALLICON			= 0x0002L,
			LVS_LIST				= 0x0003L,
			LVS_TYPEMASK			= 0x0003L,
			LVS_SINGLESEL			= 0x0004L,
			LVS_SHOWSELALWAYS		= 0x0008L,
			LVS_SORTASCENDING		= 0x0010L,
			LVS_SORTDESCENDING		= 0x0020L,
			LVS_SHAREIMAGELISTS		= 0x0040L,
			LVS_NOLABELWRAP			= 0x0080L,
			LVS_AUTOARRANGE			= 0x0100L,
			LVS_EDITLABELS			= 0x0200L,

			LVS_OWNERDATA			= 0x1000L,

			LVS_NOSCROLL			= 0x2000L,

			LVS_TYPESTYLEMASK		= 0xfc00L,

			LVS_ALIGNTOP			= 0x0000L,
			LVS_ALIGNLEFT			= 0x0800L,
			LVS_ALIGNMASK			= 0x0c00L,

			LVS_OWNERDRAWFIXED		= 0x0400L,
			LVS_NOCOLUMNHEADER		= 0x4000L,
			LVS_NOSORTHEADER		= 0x8000L,
			
			MASK					= 0xFFFFL,
		}
		#endregion

		#region TVS
		[Flags]
		public enum TVS : long
		{
			TVS_HASBUTTONS			= 0x0001L,
			TVS_HASLINES			= 0x0002L,
			TVS_LINESATROOT			= 0x0004L,
			TVS_EDITLABELS			= 0x0008L,
			TVS_DISABLEDRAGDROP		= 0x0010L,
			TVS_SHOWSELALWAYS		= 0x0020L,
			TVS_RTLREADING			= 0x0040L,

			TVS_NOTOOLTIPS			= 0x0080L,
			TVS_CHECKBOXES			= 0x0100L,
			TVS_TRACKSELECT			= 0x0200L,
			TVS_SINGLEEXPAND		= 0x0400L,
			TVS_INFOTIP				= 0x0800L,
			TVS_FULLROWSELECT		= 0x1000L,
			TVS_NOSCROLL			= 0x2000L,
			TVS_NONEVENHEIGHT		= 0x4000L,

			TVS_NOHSCROLL			= 0x8000L,	// TVS_NOSCROLL overrides this
			
			MASK					= 0xFFFFL,
		}
		#endregion

		#region SS
		[Flags]
		public enum SS : long
		{
			SS_LEFT				= 0x00000000L,
			SS_CENTER			= 0x00000001L,
			SS_RIGHT			= 0x00000002L,
			SS_ICON				= 0x00000003L,
			SS_BLACKRECT		= 0x00000004L,
			SS_GRAYRECT			= 0x00000005L,
			SS_WHITERECT		= 0x00000006L,
			SS_BLACKFRAME		= 0x00000007L,
			SS_GRAYFRAME		= 0x00000008L,
			SS_WHITEFRAME		= 0x00000009L,
			SS_USERITEM			= 0x0000000AL,
			SS_SIMPLE			= 0x0000000BL,
			SS_LEFTNOWORDWRAP	= 0x0000000CL,
			SS_OWNERDRAW		= 0x0000000DL,
			SS_BITMAP			= 0x0000000EL,
			SS_ENHMETAFILE		= 0x0000000FL,
			SS_ETCHEDHORZ		= 0x00000010L,
			SS_ETCHEDVERT		= 0x00000011L,
			SS_ETCHEDFRAME		= 0x00000012L,
			SS_TYPEMASK			= 0x0000001FL,
			SS_REALSIZECONTROL	= 0x00000040L,
			SS_NOPREFIX			= 0x00000080L, /* Don't do "&" character translation */
			SS_NOTIFY			= 0x00000100L,
			SS_CENTERIMAGE		= 0x00000200L,
			SS_RIGHTJUST		= 0x00000400L,
			SS_REALSIZEIMAGE	= 0x00000800L,
			SS_SUNKEN			= 0x00001000L,
			SS_EDITCONTROL		= 0x00002000L,
			SS_ENDELLIPSIS		= 0x00004000L,
			SS_PATHELLIPSIS		= 0x00008000L,
			SS_WORDELLIPSIS		= 0x0000C000L,
			SS_ELLIPSISMASK		= 0x0000C000L,
			
			MASK				= 0x0000FFFFL,
		}
		#endregion

		#region UDS
		[Flags]
		public enum UDS : long
		{
			UDS_WRAP				= 0x0001L,
			UDS_SETBUDDYINT			= 0x0002L,
			UDS_ALIGNRIGHT			= 0x0004L,
			UDS_ALIGNLEFT			= 0x0008L,
			UDS_AUTOBUDDY			= 0x0010L,
			UDS_ARROWKEYS			= 0x0020L,
			UDS_HORZ				= 0x0040L,
			UDS_NOTHOUSANDS			= 0x0080L,
			UDS_HOTTRACK			= 0x0100L,
			
			MASK					= 0xFFFFL,
		}
		#endregion

		#region TBS
		[Flags]
		public enum TBS : long
		{
			TBS_AUTOTICKS			= 0x0001L,
			TBS_VERT				= 0x0002L,
			TBS_HORZ				= 0x0000L,
			TBS_TOP					= 0x0004L,
			TBS_BOTTOM				= 0x0000L,
			TBS_LEFT				= 0x0004L,
			TBS_RIGHT				= 0x0000L,
			TBS_BOTH				= 0x0008L,
			TBS_NOTICKS				= 0x0010L,
			TBS_ENABLESELRANGE		= 0x0020L,
			TBS_FIXEDLENGTH			= 0x0040L,
			TBS_NOTHUMB				= 0x0080L,
			TBS_TOOLTIPS			= 0x0100L,
			TBS_REVERSED			= 0x0200L,	// Accessibility hint: the smaller number (usually the min value) means "high" and the larger number (usually the max value) means "low"

			TBS_DOWNISLEFT			= 0x0400L,	// Down=Left and Up=Right (default is Down=Right and Up=Left)

			MASK					= 0xFFFFL,
		}
		#endregion

		#region DTS
		[Flags]
		public enum DTS : long
		{
			DTS_UPDOWN					= 0x0001L, // use UPDOWN instead of MONTHCAL
			DTS_SHOWNONE				= 0x0002L, // allow a NONE selection
			DTS_SHORTDATEFORMAT 		= 0x0000L, // use the short date format (app must forward WM_WININICHANGE messages)
			DTS_LONGDATEFORMAT			= 0x0004L, // use the long date format (app must forward WM_WININICHANGE messages)
			DTS_SHORTDATECENTURYFORMAT	= 0x000CL, // short date format with century (app must forward WM_WININICHANGE messages)
			DTS_TIMEFORMAT				= 0x0009L, // use the time format (app must forward WM_WININICHANGE messages)
			DTS_APPCANPARSE				= 0x0010L, // allow user entered strings (app MUST respond to DTN_USERSTRING)
			DTS_RIGHTALIGN				= 0x0020L, // right-align popup instead of left-align it
			
			MASK						= 0x00FFL,
		}
		#endregion

		#region MCS
		[Flags]
		public enum MCS : long
		{
			MCS_DAYSTATE		= 0x0001L,
			MCS_MULTISELECT		= 0x0002L,
			MCS_WEEKNUMBERS		= 0x0004L,
//#if (_WIN32_IE >= 0x0400)
			MCS_NOTODAYCIRCLE	= 0x0008L,
			MCS_NOTODAY			= 0x0010L,
//#else
//            MCS_NOTODAY			= 0x0008L,
//#endif
			MASK				= 0x00FFL,
		}
		#endregion

		#region HT
		[Flags]
		public enum HT : long
		{
			HTERROR			=	(-2),
			HTTRANSPARENT	=	(-1),
			HTNOWHERE		=	0,
			HTCLIENT		=	1,
			HTCAPTION		=	2,
			HTSYSMENU		=	3,
			HTGROWBOX		=	4,
			HTSIZE			=	HTGROWBOX,
			HTMENU			=	5,
			HTHSCROLL		=	6,
			HTVSCROLL		=	7,
			HTMINBUTTON		=	8,
			HTMAXBUTTON		=	9,
			HTLEFT			=	10,
			HTRIGHT			=	11,
			HTTOP			=	12,
			HTTOPLEFT		=	13,
			HTTOPRIGHT		=	14,
			HTBOTTOM		=	15,
			HTBOTTOMLEFT	=	16,
			HTBOTTOMRIGHT	=	17,
			HTBORDER		=	18,
			HTREDUCE		=	HTMINBUTTON,
			HTZOOM			=	HTMAXBUTTON,
			HTSIZEFIRST		=	HTLEFT,
			HTSIZELAST		=	HTBOTTOMRIGHT,

			HTOBJECT		=	19,
			HTCLOSE			=	20,
			HTHELP			=	21,
		}
		#endregion

		#region WM
		public const int WM_NCHITTEST = 0x84;
		#endregion

		#region GetWindowLong
		[DllImport("user32.dll", SetLastError = true, CharSet = CharSet.Auto)]
		public static extern UInt32 GetWindowLong(IntPtr hWnd, GWL index);

		public static UInt32 GetWindowLong(Control ctrl, GWL index)
		{
			return GetWindowLong((IntPtr)ctrl.Handle, index);
		}
		#endregion

		#region SetWindowLong
		[DllImport("user32.dll", SetLastError = true, CharSet = CharSet.Auto)]
		public static extern UInt32 SetWindowLong(IntPtr hWnd, GWL index, UIntPtr uiValue);

		public static UInt32 SetWindowLong(Control ctrl, GWL index, UIntPtr uiValue)
		{
			return SetWindowLong((IntPtr)ctrl.Handle, index, uiValue);
		}
		#endregion

		#region SendMessage
		[DllImport("user32.dll", SetLastError = true, CharSet = CharSet.Auto)]
		public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, IntPtr wParam, IntPtr lParam);
		#endregion
	}

}	// end of namespace crisp

