# Reborn Maintenance App Trigger Handlers
# Created by Azaiel for RebornOS
# Maintained by Keegan for RebornOS
# This is an open-source project using Python3.  Feel free to use
# what you'd like, but please give credit!  Improvements are always welcome!
# RebornOS Discord: Azaiel
# RebornOS Discord: Keegan

# This ensures that the Gtk version is 3.0
import subprocess
import gi
import os
import time
from pathlib import Path
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk
gi.require_version('Notify', '0.7')
from gi.repository import Notify
Notify.init("RebornOS FIRE")
try:
    import httplib
except:
    import http.client as httplib

# Create variables for both the current working directory and the location of the settings file
workingDirectory = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..'))
settingsFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Settings', 'settings.json'))
packageFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Settings', 'packages.txt'))
runFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Settings', 'neverRun.txt'))
startupFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Bash', 'StartupChecks.sh'))
bashFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Bash', 'Maintenance.sh'))
gladeFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Glade', 'RebornMaintenance.glade'))
UnnecessaryFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Python', 'RebornUnnecessary.py'))
SelectFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Python', 'RebornSelect.py'))
RemoveFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Python', 'RebornRemove.py'))
DowngradeFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Python', 'RebornDowngrade.py'))
SettingsFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Python', 'RebornSettings.py'))
MycroftDesktopFile = os.path.abspath(os.path.join(os.path.dirname( __file__ ), '..', 'Mycroft', 'mycroft.desktop'))

installApricity = 'bash ' + workingDirectory + '/reborn-updates Apricity'
installPantheon = 'bash ' + workingDirectory + '/reborn-updates Pantheon'

# Update files that hold the lists of LigthDM and SDDM greeters + themes currently on the system, as well as the potential rollback opportunities
os.system('bash ' + startupFile + ' FirstTime ' + runFile + ' ' + packageFile + ' ' + SettingsFile + ' ' + workingDirectory)
os.system('bash ' + startupFile + ' DisplayLightDMgreeters ' + workingDirectory)
os.system('bash ' + startupFile + ' DisplaySDDMgreeters ' + workingDirectory)
os.system('bash ' + startupFile + ' StorePacmanLog ' + workingDirectory)
# Change button text to reflect if said button will be installing or removing an application (currently only used for Anbox)
os.system('bash ' + startupFile + ' isInstalled ' + workingDirectory)

# Check for Internet connection
conn = httplib.HTTPConnection("www.google.com", timeout=5)
try:
    conn.request("HEAD", "/")
    conn.close()
except:
    conn.close()
    Notify.Notification.new("Lacking Internet connection. Some options may not work").show()

# Create Handlers (Triggers) for each item
class Handler:
    def __init__(self):
        self.listoptions1 = [0,0,0,0,0]
        self.listoptions2 = [0,0,0,0,0]

# Close the window
    def onDestroy(self, *args):
        Gtk.main_quit()

################################################################################
############################### Top Menu ######################################
################################################################################

# Launch the settings window
    def RebornSettings(self, button):
        os.system('python3 ' + SettingsFile)

################################################################################
############################### First Tab ######################################
################################################################################

# Set LightDM as default
    def LightDMdefault(self, button):
        os.system('pkexec bash ' + bashFile + ' LightDMdefault')
        Notify.Notification.new("LightDM set as default").show()

# Set SDDM as default
    def SDDMdefault(self, button):
        os.system('pkexec bash ' + bashFile + ' SDDMdefault')
        Notify.Notification.new("SDDM set as default").show()

# Set LightDM greeter
    def lightdmUse(self, pkgtxt):
        global enteredText
        enteredText = pkgtxt.get_text()
        os.system('pkexec bash ' + bashFile + ' LightDM ' + enteredText)
        Notify.Notification.new("LightDM greeter changed").show()

# Set SDDM theme
    def sddmUse(self, pkgtxt):
        global enteredText
        enteredText = pkgtxt.get_text()
        os.system('pkexec bash ' + bashFile + ' SDDM ' + enteredText)
        Notify.Notification.new("SDDM greeter changed").show()

# Test a LightDM greeter
    def lightdmTest(self, pkgtxt):
        global enteredText
        enteredText = pkgtxt.get_text()
        os.system('bash ' + bashFile + ' TestLightdm ' + enteredText)

# Test a SDDM theme
    def sddmTest(self, pkgtxt):
        global enteredText
        enteredText = pkgtxt.get_text()
        os.system('sddm-greeter --test-mode --theme /usr/share/sddm/themes/' + enteredText)

################################################################################
############################### Second Tab ######################################
################################################################################

# Install Apricity
    def clickApricity(self, button):
        subprocess.Popen(['xterm', '-e', installApricity])

    # Install Budgie
    def clickBudgie(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment budgie ' + settingsFile)

    # Install Cinnamon
    def clickCinnamon(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment cinnamon ' + settingsFile)

    # Install Deepin
    def clickDeepin(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment deepin ' + settingsFile)

    # Install Enlightenment
    def clickEnlightenment(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment enlightenment ' + settingsFile)

    # Install GNOME
    def clickGnome(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment gnome ' + settingsFile)

    # Install i3
    def clicki3(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment i3 ' + settingsFile)

    # Install Plasma
    def clickPlasma(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment plasma ' + settingsFile)

    # Install LXQt
    def clickLXQt(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment lxqt ' + settingsFile)

    # Install Mate
    def clickMate(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment mate ' + settingsFile)

    # Install Openbox
    def clickOpenbox(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment openbox ' + settingsFile)

    # Install Pantheon
    def clickPantheon(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment pantheon ' + settingsFile)

    # Install XFCE
    def clickXFCE(self, button):
        os.system('bash ' + bashFile + ' DesktopEnvironment xfce ' + settingsFile)

################################################################################
############################### Third Tab ######################################
################################################################################

    # Clear Pacman's cache completely
    def onClearCache(self, switch, state):
        if state == True:
            self.listoptions1[0]=1
        else:
            self.listoptions1[0]=0

    # Clean the system journal excepting the last 3 days worth of text
    def onCleanJournal(self, switch, state):
        if state == True:
            self.listoptions1[1]=1
        else:
            self.listoptions1[1]=0

    # Clean package list
    def onCleanPackages(self, switch, state):
        if state == True:
            self.listoptions1[2]=1
        else:
            self.listoptions1[2]=0

    # Rank the mirrors
    def onRankMirrors(self, switch, state):
        if state == True:
            self.listoptions1[3]=1
        else:
            self.listoptions1[3]=0

    # Allow the user to remove programs that are no longer necessary - orphans, depreciated, etc
    def onUnnecessaryPrograms(self, switch, state):
        if state == True:
            self.listoptions1[4]=1
        else:
            self.listoptions1[4]=0

    # Apply select changes from above
    def clickApply1(self, button):
        print(self.listoptions1)
        if self.listoptions1[0] == 1:
            print("Clearing Cache (leaving nothing behind)...")
            os.system('yes| pkexec pacman -Scc')
            Notify.Notification.new("Cache Cleared (leaving nothing behind)").show()

        if self.listoptions1[1] == 1:
            print("Cleaning Journal...")
            os.system('pkexec journalctl --vacuum-time=3d && sync')
            Notify.Notification.new("Journal Cleaned").show()

        if self.listoptions1[2] == 1:
            print("Cleaning Package Cache (leaving the 3 most recent package versions)...")
            os.system('pkexec paccache -ruk0')
            Notify.Notification.new("Package Cache Cleaned (leaving the 3 most recent package versions)").show()

        if self.listoptions1[3] == 1:
            print("Ranking Mirrors...")
            Notify.Notification.new("Ranking Mirrors...").show()
            os.system('pkexec reflector --verbose -p https --sort rate --save /etc/pacman.d/mirrorlist')
            Notify.Notification.new("Mirrors Ranked").show()

        if self.listoptions1[4] == 1:
            Notify.Notification.new("Generating Package List...").show()
            os.system('rm -f ' + workingDirectory + '/package-files.txt')
            os.system('pkexec pacman -Qdtq >' + workingDirectory + '/package-files.txt')
            os.system('python3 ' + UnnecessaryFile)

################################################################################
############################### Fourth Tab #####################################
################################################################################

    def onSaveRecoverPackages(self, switch, state):
        if state == True:
            self.listoptions2[0]=1
        else:
            self.listoptions2[0]=0

    def onRebuildGrub(self, switch, state):
        if state == True:
            self.listoptions2[1]=1
        else:
            self.listoptions2[1]=0

    def onReinstallGrubEFI(self, switch, state):
        if state == True:
            self.listoptions2[2]=1
        else:
            self.listoptions2[2]=0

    def onDowngrade(self, switch, state):
        if state == True:
            self.listoptions2[3]=1
        else:
            self.listoptions2[3]=0

    def onRemovePackage(self, switch, state):
        if state == True:
            self.listoptions2[4]=1
        else:
            self.listoptions2[4]=0

    def clickApply2(self, button):
        print(self.listoptions2)
        if self.listoptions2[0] == 1:
            print("Save/Recover Packages...")
            os.system('python3 ' + SelectFile)
            Notify.Notification.new("Operation Complete").show()

        if self.listoptions2[1] == 1:
            print("Reinstalling Grub...")
            Notify.Notification.new("Reinstalling Grub...").show()
            os.system('pkexec pacman -S grub --noconfirm')
            Notify.Notification.new("Grub has Been Reinstalled").show()

        if self.listoptions2[2] == 1:
            print("Rebuilding Grub (EFI)...")
            os.system('pkexec bash ' + bashFile + ' Grub')
            Notify.Notification.new("Grub is Rebuilt").show()

        if self.listoptions2[3] == 1:
            print("Downgrading interface started...")
            os.system('python3 ' + DowngradeFile)
            Notify.Notification.new("Package Downgraded").show()

        if self.listoptions2[4] == 1:
            print("Package Removal interface started...")
            os.system('python3 ' + RemoveFile)
            Notify.Notification.new("Package Removed").show()

################################################################################
############################### Fifth Tab ######################################
################################################################################

    def rollbackUse(self, pkgtxt):
        global enteredText
        enteredText = pkgtxt.get_text()
        os.system('pkexec bash ' + bashFile + ' Rollback ' + enteredText + ' ' + workingDirectory + '/transactions.txt ' + settingsFile)
        Notify.Notification.new("Rollback Complete. Please Reboot for Full Effect").show()

    def resetRollbackUse(self, button):
        os.system('bash ' + bashFile + ' ResetRollback ' + settingsFile)

################################################################################
############################### Sixth Tab ######################################
################################################################################

    # Control Mycroft
    def clickControlMycroft(self, button):
        # Check to see if Mycroft/s desktop file already is already in place
        mycroftFile = Path("/usr/share/applications/mycroft.desktop")
        if mycroftFile.exists():
            os.system('pkexec bash ' + bashFile + ' RemoveMycroft ' + settingsFile)
        else:
            os.system('pkexec cp ' + MycroftDesktopFile + ' /usr/share/applications/')
            os.system('python3 ' + workingDirectory + '/Mycroft/mycroft-reborn.py &')

    # Control Anbox
    def clickControlAnbox(self, button):
        os.system('pkexec bash ' + bashFile + ' InstallAnbox')

    # Send File with Wormhole
    def wormholeFile(self, menuitem):
        global filechosen
        filechosen = menuitem.get_file().get_path()
        os.system('pkexec bash ' + bashFile + ' SetupWormhole ' + filechosen)

    # Send Folder with Wormhole
    def wormholeFolder(self, menuitem):
        global filechosen
        filechosen = menuitem.get_file().get_path()
        print(filechosen)
        os.system('pkexec bash ' + bashFile + " SetupWormhole '" + filechosen + "'")

    # Receive File / Folder with Wormhole
    def wormholeReceive(self, pkgtxt):
        global enteredText
        enteredText = pkgtxt.get_text()
        os.system('pkexec bash ' + bashFile + ' ReceiveWormhole ' + enteredText)

################################################################################
############################### Seventh Tab ######################################
################################################################################

    # Open Pace
    def clickPacman(self, button):
        os.system('bash ' + bashFile + ' InstallTools pace ' + settingsFile)

    # Open Arch Kernel Manager
    def clickKernel(self, button):
        os.system('bash ' + bashFile + ' InstallTools pyakm-manager ' + settingsFile)

    # Open Stacer
    def clickStacer(self, button):
        os.system('bash ' + bashFile + ' InstallTools stacer ' + settingsFile)

    # Open Pamac
    def clickPamac(self, button):
        os.system('bash ' + bashFile + ' InstallTools pamac-manager ' + settingsFile)

################################################################################
############################### Drawing App Window #############################
################################################################################

builder = Gtk.Builder()
builder.add_from_file(gladeFile)
builder.connect_signals(Handler())

# =====================================
# View the file when the window pops up
# =====================================
with open(workingDirectory + '/lightdm.txt', 'r') as lightdmFile:
    lightdmData = lightdmFile.read()
    builder.get_object("lightdmView").get_buffer().set_text(lightdmData)
# =====================================

# =====================================
# View the file when the window pops up
# =====================================
with open(workingDirectory + '/sddm.txt', 'r') as sddmFile:
    sddmData = sddmFile.read()
    builder.get_object("sddmView").get_buffer().set_text(sddmData)
# =====================================

# =====================================
# View the file when the window pops up
# =====================================
with open(workingDirectory + '/Settings/transactions.txt', 'r') as rollbackFile:
    rollbackData = rollbackFile.read()
    builder.get_object("rollbackView").get_buffer().set_text(rollbackData)
# =====================================

window2 = builder.get_object("Reborn")
window2.show_all()

Gtk.main()

Notify.uninit()
