#!/bin/bash
directory=/usr/share/RUM
lightdmGreeters=lightdm.txt
sddmGreeters=sddm.txt

function isRebornOS() {
      true=0
      false=1
      if [ -f /etc/pacman.d/reborn-mirrorlist ]; then
            return $true
      else
            return $false
      fi
}

function FirstTime() {
      if [ -f $1 ]; then
            Install $2 $3 $4
            rm -f $1
      fi
      # If RebornOS is not the distro being run, check for updates
      if ! isRebornOS ; then
            localRUMFile=$($4/*zst | rev | cut -f1 -d "/" | rev)
            # Download a file with a list of all packages on the RebornOS repository
            curl -o rebornos.txt http://repo.rebornos.org/RebornOS/
            remoteRUMFile=$(grep "reborn-updates." rebornos.txt | cut -f2 -d "\"" | cut -d "\"" -f1 | grep -v "sig")
            # If the local RUM package file and the one from the server are not identical, install the updated one from Gitlab (aka. upgrade RUM without messing with signatures)
            if [ "$localRUMFile" != "$remoteRUMFile" ]; then
                  curl -o $4/$remoteRUMFile https://gitlab.com/reborn-os-team/reborn-updates-and-maintenance/-/raw/master/$remoteRUMFile
                  pkexec pacman -U $4/$remoteRUMFile --noconfirm
            fi
            # Remove old RUM file
            rm -f $4/$localRUMFile
            # Remove files generated by this function
            rm -f rebornos.txt
      fi
}

function Install() {
    RUID=$(who | awk 'FNR == 1 {print $1}')
    # Piece together the command to install packages via pacman
    command="pacman -S"
    while read package; do
        command+=" $package"
    done <$1
    command+=" --needed --noconfirm"
    echo "$command"
    # Download and install yay from the main RebornOS repository
    curl -o rebornos.txt http://repo.rebornos.org/RebornOS/
    yayFile=$(grep "yay" rebornos.txt | cut -f2 -d "\"" | cut -d "\"" -f1 | grep -v "sig")
    # Install packages with only one pkexec dialog
    pkexec bash $3/Bash/StartupChecks.sh PacmanYay "$command" $yayFile
    # Remove the downloaded pkg file
    rm -f $yayFile
    # Remove files generated by this function
    rm -f rebornos.txt
    # Launch the setting dialog so the user can select a terminal
    notify-send "Please select a terminal, and then close the window" -u critical -i "/usr/share/icons/default/reborn-updates.svg" -a "Reborn Updates and Maintenance"
    python3 $2
}

function PacmanYay()
{
      # Install necessary packages from pacman
      $1
      # Install yay
      wget http://repo.rebornos.org/RebornOS/$2
      pkexec pacman -U $2 --needed --noconfirm
      # Remove files generated by this function
      rm -f $2
}

function DisplayLightDMgreeters() {
      DMdirectory=$1
      if [ -d /usr/share/lightdm-webkit/themes/ ]; then
            ls /usr/share/lightdm-webkit/themes/ | sed "s|.desktop||g" >$DMdirectory/Settings/$lightdmGreeters
      fi
      if [ -f /etc/lightdm/lightdm-gtk-greeter.conf ]; then
            echo "lightdm-gtk-greeter" >>$DMdirectory/Settings/$lightdmGreeters
      fi
}

function DisplaySDDMgreeters() {
      DMdirectory=$1
      ls -l /usr/share/sddm/themes/ | awk '{print $9}' | sed 1d >$DMdirectory/Settings/$sddmGreeters
}

export -f Install PacmanYay DisplayLightDMgreeters DisplaySDDMgreeters FirstTime isRebornOS

"$@"
