#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import os
import sqlite3
import chdb
import datetime
import ts2epg
import xml2db
#import japanesenkf
#japanesenkf.overrideEncodings()
path=str(os.path.dirname(os.path.abspath(__file__)))+"/"
tmppath=path
def update(chtxt):
    print chtxt
    tnow=datetime.datetime.now()
    try:
        lastup=datetime.datetime.strptime(chdb.chtxtsearch(chtxt)[0]['update'],"%Y-%m-%d %H:%M:%S")
    except:
        lastup=datetime.datetime.strptime("2009-04-01 00:00:00","%Y-%m-%d %H:%M:%S")
    dt=tnow-lastup
    dt=dt.days*24*60+dt.seconds
    #print dt
    if dt>2*60*60:
        ts2epg.write(tmppath+"epgdate.xml",chdb.chtxtsearch(chtxt)['ch'])
        xml2db.xml2db(tmppath+"epgdate.xml",path+"ch.db",chdb.chtxtsearch(chtxt)['bctype'])
        #os.remove(path+"epgdate.xml")
def updatebc(bctype):
    #print bctype
    #tnow=datetime.datetime.now()
    bctypel=chdb.bctypesearch(bctype)
    print bctypel
    ts2epg.write(tmppath+"epgdate.xml",chdb.bctypesearch(bctype)['ch'])
    xml2db.xml2db(tmppath+"epgdate.xml",path+"ch.db",bctype)
    #os.remove(path+"epgdate.xml")
def updateall():
    update("hisch")
    update("nhk-k")
    update("nhk-s")
    update("me-tere")
    update("cbc")
    update("aichi")
    update("toukai")
    update("chukyo")
    update("bs-nhk-1")
    
def search(titletxt):
    dbpath=path+"ch.db"
    db=sqlite3.connect(dbpath)
    #print dbpath
    ret=[]
    for ch, title, start, stop in db.execute("SELECT channel,title,start,stop FROM tv WHERE title LIKE \"%"+titletxt+"%\""):
        btime=start.replace(" +0900","")
        btime=btime[0:4]+"-"+btime[4:6]+"-"+btime[6:8]+" "+btime[8:10]+":"+btime[10:12]+":00"
        etime=stop.replace(" +0900","")
        etime=etime[0:4]+"-"+etime[4:6]+"-"+etime[6:8]+" "+etime[8:10]+":"+etime[10:12]+":00"
        try:
            chtxt=chdb.ontvsearch(ch)['chtxt']
        except:
            chtxt="Unknown"
            #print ch
        ret.append(chtxt+","+title.encode('utf-8')+","+btime+","+etime)

    #r=db.execute("SELECT * FROM tv")
    #for row in r:
    #	print unicode(row)
    #row=r.fetchone()
    #print r
    db.close()
    return ret
def searchtime(titletxt,time,deltatime):#時間以内のものだけを表示 deltatimeはhours
    dbpath=path+"ch.db"
    db=sqlite3.connect(dbpath)
    #print dbpath
    ret=[]
    deltatime=int(deltatime)
    for ch, title, start, stop in db.execute("SELECT channel,title,start,stop FROM tv WHERE title LIKE \"%"+titletxt+"%\""):
        btime=start.replace(" +0900","")
        btime=btime[0:4]+"-"+btime[4:6]+"-"+btime[6:8]+" "+btime[8:10]+":"+btime[10:12]+":00"
        etime=stop.replace(" +0900","")
        etime=etime[0:4]+"-"+etime[4:6]+"-"+etime[6:8]+" "+etime[8:10]+":"+etime[10:12]+":00"
        bt=datetime.datetime.strptime(btime,"%Y-%m-%d %H:%M:%S")
        t=datetime.datetime.strptime(time,"%Y-%m-%d %H:%M:%S")
        try:
            chtxt=chdb.ontvsearch(ch)['chtxt']
        except:
            chtxt="Unknown"
            #print ch
        dt=bt-t
        dt=dt.days*24*60*60+dt.seconds
        dt=abs(dt)
        if dt<deltatime*60*60:
            ret.append(chtxt+","+title.encode('utf-8')+","+btime+","+etime)

    #r=db.execute("SELECT * FROM tv")
    #for row in r:
    #	print unicode(row)
    #row=r.fetchone()
    #print r
    db.close()
    return ret

