/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.validator;

import com.nexaweb.plugin.validation.exceptions.ValidationException;
import com.nexaweb.xml.Element;
import java.util.Properties;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValue;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValues;
import jp.co.fujitsu.reffi.client.nexaweb.validator.CustomValidator;
import jp.co.fujitsu.reffi.common.util.ResourceUtil;

public class ByteLengthValidator
extends CustomValidator {
    private final String MESSAGE_RESOURCE = "jp.co.fujitsu.reffi.common.exception.corelogic_message";
    private int max;
    private int min;

    public void setBytesRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public ByteLengthValidator(Element element) {
        super(element);
    }

    @Override
    public String registerErrorMessage() {
        Properties messages = ResourceUtil.instance.asProperties("jp.co.fujitsu.reffi.common.exception.corelogic_message");
        return messages.getProperty("EFC2004");
    }

    protected boolean validate(Object value) throws ValidationException {
        ElementValues values = (ElementValues)value;
        int max = this.max;
        int min = this.min;
        for (int i = 0; i < values.size(); ++i) {
            ElementValue elementValue = values.getElementValue(i);
            String v = elementValue.getValue();
            if (v.getBytes().length >= min && v.getBytes().length <= max) continue;
            return false;
        }
        return true;
    }
}

