/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.logconsumer;

import com.nexaweb.client.ClientSession;
import com.nexaweb.client.netservice.NetServiceException;
import com.nexaweb.util.LogConsumer;
import com.nexaweb.util.LogEvent;
import com.nexaweb.xml.Document;
import com.nexaweb.xml.Element;
import java.net.SocketException;
import java.util.Properties;
import jp.co.fujitsu.reffi.client.nexaweb.util.DialogUtil;
import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialog;
import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialogIF;
import jp.co.fujitsu.reffi.common.util.ResourceUtil;

public class DialogLogConsumer
implements LogConsumer {
    private final String MESSAGE_RESOURCE = "jp.co.fujitsu.reffi.common.exception.corelogic_message";
    private Element _dialog;
    private ClientSession _session;

    public void init(Object obj) {
        if (obj instanceof ClientSession) {
            this._session = (ClientSession)obj;
            try {
                this._session.getMcoContainer().addMco("dialogLogConsumer", (Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void log(LogEvent logevent) {
        logevent.getThrowable();
        Throwable e = logevent.getThrowable();
        if ((logevent.getType() == 4 || logevent.getType() == 3) && this.recursiveCheckConnectError(e)) {
            this.addMessage(logevent.toString());
        }
    }

    private boolean recursiveCheckConnectError(Throwable e) {
        boolean result = false;
        if (e instanceof SocketException) {
            result = true;
        } else if (e instanceof NetServiceException && ((NetServiceException)e).getCausalThrowable() != null) {
            result = this.recursiveCheckConnectError(((NetServiceException)e).getCausalThrowable());
        } else if (e.getCause() != null) {
            result = this.recursiveCheckConnectError(e.getCause());
        }
        return result;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        Object object = this._session.getDocumentRegistry().getUiDocument().getDomSynchronizationObject();
        synchronized (object) {
            this._dialog.setAttribute("visible", "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(String message) {
        Object object = this._session.getDocumentRegistry().findDocument("ui").getDomSynchronizationObject();
        synchronized (object) {
            Document uiDoc = this._session.getDocumentRegistry().getUiDocument();
            Element rootPane = DialogUtil.getRootPane(uiDoc);
            Properties messages = ResourceUtil.instance.asProperties("jp.co.fujitsu.reffi.common.exception.corelogic_message");
            String id = "EFC1009";
            String msg = messages.getProperty(id);
            CoreDialog cmd = new CoreDialog.Builder(id, msg).dialogType(CoreDialog.MessageDialogType.ERROR.getType()).build();
            if (this._dialog == null) {
                this._dialog = DialogUtil.getElement((CoreDialogIF)cmd);
            }
            rootPane.appendChild(this._dialog);
        }
    }
}

