/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.flex.producer;

import flex.messaging.MessageBroker;
import flex.messaging.MessageClient;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.UUIDUtils;
import java.io.Serializable;
import jp.co.fujitsu.reffi.server.messaging.AbstractMessageSender;

public abstract class ProxyMessageProducer
extends AbstractMessageSender {
    private static final String DEFAULT_SERVICE_ID = "message-service";
    private MessageBroker _broker;
    private String _clientID;
    private MessageClient _messageClient;
    private String _serviceID = "message-service";

    public String getServiceID() {
        return this._serviceID;
    }

    public void setServiceID(String serviceID) {
        this._serviceID = serviceID;
    }

    public MessageClient getMessageClient() {
        return this._messageClient;
    }

    public void setMessageClient(MessageClient messageClient) {
        this._messageClient = messageClient;
    }

    protected final void send(String destination, Serializable object) {
        if (this.getMessageBroker() == null) {
            return;
        }
        try {
            AsyncMessage msg = new AsyncMessage();
            msg.setDestination(destination);
            msg.setClientId((Object)this.getClientID());
            msg.setMessageId(UUIDUtils.createUUID());
            msg.setTimestamp(System.currentTimeMillis());
            msg.setBody((Object)object);
            if (this.getMessageClient() != null) {
                this.getMessageBroker().routeMessageToMessageClient((Message)msg, this.getMessageClient());
            } else {
                this.getMessageBroker().routeMessageToService((Message)msg, null);
            }
        }
        catch (Exception e) {
            this.trap(e);
        }
    }

    private MessageBroker getMessageBroker() {
        if (this._broker == null) {
            this._broker = MessageBroker.getMessageBroker(null);
        }
        return this._broker;
    }

    private String getClientID() {
        if (this._clientID == null) {
            this._clientID = UUIDUtils.createUUID();
        }
        return this._clientID;
    }
}

