/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.controller {
	import flash.events.MouseEvent;
	
	import mx.containers.TitleWindow;
	import mx.containers.VBox;
	import mx.controls.TextArea;
	import mx.events.CloseEvent;
	
	/**
	 * <p>[概 要]</p>
	 * コントローラにてキャッチしたエラーを表示するダイアログコンポーネント.
	 * 
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 * 本クラスはReffiのコントローラ内部で利用するものなので、殆どの場合において
	 * 直接利用することはありません。
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */ 
	public class ErrorDialog extends TitleWindow {
		/** デフォルトタイトル */
		public static const DEFAULT_TITLE:String = "Error";
		/** エラー情報出力テキストエリア */
		private var _textArea:TextArea;
		/** 画面構成ボックス*/
		private var _vbox:VBox;
		/** 表示エラータイトル */
		private var _errorTitle:String;
		/** 表示エラーメッセージ */
		private var _errorMessage:String;
		
		/**
		 * <p>[概 要]</p>
		 * コンストラクタです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function ErrorDialog() {
			super();
			this.width = 360;
			this.height = 240;
			this.title = DEFAULT_TITLE;
			this.showCloseButton = true;
			//イベント登録
			addEventListener(CloseEvent.CLOSE,closeHandler);
		}
		
		/**
		 * <p>[概 要]</p>
		 * 画面の描画情報を更新します.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number):void {
			super.updateDisplayList(unscaledWidth, unscaledHeight);
			this.title = this.errorTitle;
			this._textArea.text = this.errorMessage;
		}
		
		/**
		 * <p>[概 要]</p>
		 * 画面構成を構築します.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		override protected function createChildren():void {
			super.createChildren();

			this._vbox = new VBox();
			this._vbox.percentWidth = 100;
			this._vbox.percentHeight = 100;
			this.addChild(this._vbox);

			this._textArea = new TextArea();
			this._textArea.percentWidth = 100;
			this._textArea.percentHeight = 100;
			this._textArea.editable = false;
			this._vbox.addChild(this._textArea);
		}
		
		/**
		 * <p>[概 要]</p>
		 * 画面を閉じる際のイベントハンドラーです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function closeHandler(event:CloseEvent):void {
			this.removeEventListener(CloseEvent.CLOSE, closeHandler);
			this.parent.removeChild(this);
		}
		
		/**
		 * <p>[概 要]</p>
		 * 画面に表示するエラーメッセージのプロパティです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get errorMessage():String {
			return this._errorMessage;
		}
		
		public function set errorMessage(errorMessage:String):void {
			this._errorMessage = errorMessage;
		}
		
		/**
		 * <p>[概 要]</p>
		 * 画面に表示するエラータイトルのプロパティです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get errorTitle():String {
			return this._errorTitle;
		}
		
		public function set errorTitle(errorTitle:String):void {
			this._errorTitle = errorTitle;
		}
	}
}
