/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.events{
	
	import flash.events.Event;
	
	/**
	 * <p>[概 要]</p>
	 * LocalConnectionイベントクラス.
	 * 
	 * <p>[詳 細]</p>
	 * LocalConnectionが以下の状態になった時に発行されるイベント情報を保持します。
	 * <ul>
	 *   <li>RECEIVE：受信成功</li>
	 * </ul>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * <p>Copyright (c) 2008-2010 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */
	public class LocalConnectionEvent extends Event{

		/** LocalConnectionの受信が成功したことを示す定数です */
		public static const RECEIVE:String = 'receive';
	    
		/** LocalConnectionのsendメソッド実行時の引数 */
		public var _args:Array = null;

		/**
		 * <p>[概 要]</p>
		 * LocalConnectionのsendメソッド実行時の引数です.
		 * 
		 * <p>[詳 細]</p>
		 * このプロパティから、LocalConnectionのsendメソッド実行時に使用した引数にアクセスできます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get args():Array{
			return this._args;
		}
		public function set args(args:Array):void{
			this._args = args;
		}

		/**
		 * <p>[概 要]</p>
		 * コンストラクタです.
		 * 
		 * <p>[詳 細]</p>
		 * 与えられた引数を元にEventクラスのコンストラクタをコールします。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param type イベントタイプ
		 * @param args LocalConnectionのsendメソッド実行時の引数
		 * @param bubbles 
		 * @param cancelable 
		 */
      	public function LocalConnectionEvent(type:String, args:Array, bubbles:Boolean=false, cancelable:Boolean=false){
			super(type, bubbles, cancelable);
			this._args = args;
		}

		/**
		 * <p>[概 要]</p>
		 * このクラスオブジェクトの複製を返却します.
		 * 
		 * <p>[詳 細]</p>
		 * LocalConnectionEventのコピーを作成する。
		 * 
		 * <p/>
		 * @return 複製されたLocalConnectionEventオブジェクト
		 */
		override public function clone():Event {
			return new LocalConnectionEvent(type, _args);
		}   
	}
}