/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.action {

	/**
	 * <p>[概 要]</p>
	 * DispatchActionが使用するモデル、イベントハンドリングメソッド登録クラスです.
	 *  
	 * <p>[詳 細]</p>
	 * DispatchActionがModelProcessEvent.SUCCESS、ModelProcessEvent.FAILUREを
	 * ハンドリングする為の情報を保持します。<br />
	 * このオブジェクトはDispatchAction継承アクションのreserveModelsAndCallbackMethod
	 * の引数として使用されます。
	 * 
	 * <p>[備 考]</p>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * 
	 * @author Project Reffi 
	 * @see jp.co.fujitsu.reffi.client.flex.action.DispatchAction
	 */
	public class CallbackMapping {
	
		/** モデルクラスを示す定数です.*/
		public static const CLASS:String = "class";
		
		/** モデル処理成功時コールバックメソッド名を示す定数です. */
		public static const SUCCESS:String = "success";
		
		/** モデル処理失敗時コールバックメソッド名を示す定数です.*/
		public static const FAILURE:String = "failure";

		// モデル型、成功イベントハンドラ、失敗イベントハンドラのリスト
		private var _list:Array = new Array();
		
		/**
		 * <p>[概 要]</p>
		 * モデル型、成功イベントハンドラ、失敗イベントハンドラが入ったオブジェクトのリストです.
		 * 
		 * <p>[詳 細]</p>
		 * 以下のような構造を持つプロパティです。
		 * 
		 * <listing version="3.0">
		 * list:Array
		 *     0 = map:Object
		 *             "CLASS" = Class(Model)
		 *             "SUCCESS" = "event success method name"
		 *             "FAILURE" = "event failure method name"
		 *     1 = map:Object
		 *             "CLASS" = Class(Model)
		 *             "SUCCESS" = "event success method name"
		 *             "FAILURE" = "event failure method name"
		 * </listing>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get list():Array {
			return this._list;
		}
		public function set list(list:Array):void {
			this._list = list;
		}
		
		/**
		 * <p>[概 要]</p>
		 * 紐付けを追加します.
		 * 
		 * <p>[詳 細]</p>
		 * listプロパティに予約情報を追加します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @see #list
		 * @param modelClass 実行予約する機能モデルクラス型
		 * @param successMethodName modelClassのSUCCESSイベントをハンドルするメソッド名
		 * @param failureMethodName modelClassのFAILUREイベントをハンドルするメソッド名
		 */
		public function add(modelClass:Class, successMethodName:String, failureMethodName:String):void {
			var map:Object = new Object();
			map[CLASS] = modelClass;
			map[SUCCESS] = successMethodName;
			map[FAILURE] = failureMethodName;
			
			list.push(map);
		}
	
		/**
		 * <p>[概 要]</p>
		 * 引数indexに対応する予約情報を取得します.
		 * 
		 * <p>[詳 細]</p>
		 * listプロパティからindex番目の情報オブジェクトを取得して返却します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param index 取得するインデックス
		 */
		public function getMapping(index:int):Object {
			return list[index];
		}
		
		/**
		 * <p>[概 要]</p>
		 * 予約情報の数を取得します.
		 * 
		 * <p>[詳 細]</p>
		 * listプロパティのlengthを取得して返却します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @return 予約情報の数
		 */
		public function size():int {
			return list.length;
		}
	}
}
