/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.model.rpc {
	
	import flash.events.IEventDispatcher;
	import flash.utils.Dictionary;
	
	import mx.messaging.ChannelSet;
	import mx.messaging.config.ServerConfig;
	import mx.rpc.remoting.Operation;
	import mx.rpc.remoting.RemoteObject;
	
	/**
	 * <p>[概 要]</p>
	 * RemoteObjectによるリモートモジュール呼び出しをサポートする機能モデルクラスです.
	 * 
	 * <p>[詳 細]</p>
	 * サーバ側remoting-config.xmlで定義されているRPCモジュールにアクセスする為のクラスです。<br>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * @example サーバ定義されているRPCモジュールにリクエストを行う
	 * <p/>
	 * 
	 * ・サーバ側RPC定義（remoting-config.xml）
	 * <listing version="3.0">
        &lt;destination id="orderDestination"&gt;
            &lt;properties&gt;
                &lt;source&gt;test.server.OrderProcesser&lt;/source&gt;
            &lt;/properties&gt;
        &lt;/destination&gt;
	 * </listing>
	 * 
	 * ・サーバ側ロジック（OrderProcesserクラス）
	 * <listing version="3.0">
        package test.server;
        
        public class OrderProcesser {
            
            public String requestOrder(int productId, int num){
                
                String responseMessage = "";
                
                String productName = null;
                int price = 0;
                
                switch(productId) {
                    case 0:
                        productName = "ノートPC";
                        price = 120000;
                        break;
                    case 1:
                        productName = "デスクトップPC";
                        price = 180000;
                        break;
                    case 2:
                        productName = "液晶ディスプレイ";
                        price = 56000;
                        break;
                }
                
                if(productName == null) {
                    responseMessage = "productIdに対応する製品が見つかりませんでした";
                } else {
                    responseMessage = productName + "が " + num + "個注文されました：計" + price &#42; num + "円です";
                }
                return responseMessage;
            }
        }
	 * </listing>
	 * 
	 * ・クライアント側ロジック
	 * <listing version="3.0">
        package test.client.action {
            import flash.events.Event;
            
            import jp.co.fujitsu.reffi.client.flex.action.BaseAction;
            import jp.co.fujitsu.reffi.client.flex.controller.ParameterMapping;
            import jp.co.fujitsu.reffi.client.flex.events.ModelProcessEvent;
            import jp.co.fujitsu.reffi.client.flex.model.BaseModel;
            import jp.co.fujitsu.reffi.client.flex.model.rpc.RemoteObjectCore;
            
            import mx.rpc.events.ResultEvent;
        
            public class RemoteObjectAction extends BaseAction {
                
                override protected function reserveModels(models:Array):void {
                    models.push(Class(RemoteObjectCore));
                }
                
                override public function nextModel(index:int, prev:ModelProcessEvent, next:BaseModel):Boolean {
                    if(index == 0) {
                        RemoteObjectCore(next).remoteDestination = "orderDestination";
                        RemoteObjectCore(next).methodName = "requestOrder";
                        RemoteObjectCore(next).addRpcParameter(0);
                        RemoteObjectCore(next).addRpcParameter(2);
                    }
                    
                    return true;
                }
                
                override public function successForward(index:int, model:BaseModel, resultEvent:Event):void {
                    trace(ResultEvent(resultEvent).result);
                }
            }
        }
	 * </listing>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */ 
	public class RemoteObjectCore extends RPCCore {

		// RPCコントローラの宛先
		private var _remoteDestination:String;
		
		// リモートオブジェクト実行メソッド名
		private var _methodName:String;
		
		// RPCメソッド引数
		private var _rpcParameter:Array = new Array();
		
		// チャンネルセット
		private static var _channelSets:Dictionary = new Dictionary();

		/**
		 * <p>[概 要]</p>
		 * RPCリクエスト時のdestinationです.
		 * 
		 * <p>[詳 細]</p>
		 * remoting-config.xmlで設定されているRPCモジュールのdestinationを文字列で指定します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */ 
		public function get remoteDestination():String {
			return this._remoteDestination;
		}
		public function set remoteDestination(remoteDestination:String):void {
			this._remoteDestination = remoteDestination;
		}
		
		/**
		 * <p>[概 要]</p>
		 * 実行するリモートオブジェクトメソッド名です.
		 * 
		 * <p>[詳 細]</p>
		 * destinationで設定されているオブジェクトが持つメソッド名を指定します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */ 
		public function get methodName():String {
			return this._methodName;
		}
		public function set methodName(methodName:String):void {
			this._methodName = methodName;
		}
		
		/**
		 * <p>[概 要]</p>
		 * RPCメソッド引数です.
		 * 
		 * <p>[詳 細]</p>
		 * methodNameプロパティで指定したメソッドが持つ引数を設定します。<br>
		 * 第一引数、第二引数・・・と順番に値が入ります。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */ 
		public function get rpcParameter():Array {
			return this._rpcParameter;
		}
		public function set rpcParameter(rpcParameter:Array):void {
			this._rpcParameter = rpcParameter;
		}
		
		/**
		 * <p>[概 要]</p>
		 * RPCメソッド呼び出し時のパラメータに新規パラメータを追加します.
		 * 
		 * <p>[詳 細]</p>
		 * methodNameプロパティで指定したRPCメソッドが持つ引数を設定します。<br>
		 * 呼び出すRPCメソッドが以下のシグネチャを持っている場合、
		 * <p/>
		 * 
		 * boolean commitData(String name, int age);
		 * <p/>
		 * 
		 * addRpcParameter("山田太郎");<br>
		 * addRpcParameter(36);<p/>
		 * 
		 * のようにシグネチャ順に設定します。
		 * 
		 * <p>[備 考]</p>
		 */ 
		public function addRpcParameter(value:Object):Array {
			rpcParameter.push(value);
			
			return rpcParameter;
		}
		
		/**
		 * <p>[概 要]</p>
		 * RPCリクエストを行います.
		 * 
		 * <p>[詳 細]</p>
		 * RemoteObjectに対してdestination、メソッド名、パラメータを指定、
		 * リモートモジュールにリクエストします。
		 * 
		 * <p>[備 考]</p>
		 */ 
		override protected function mainProc() : void{
			super.mainProc();
			// remoting-config.xmlで設定されているRPCコントローラ参照を取得
			var service:RemoteObject = this.service as RemoteObject;
			
			// チャンネル情報を取得
			var channelSetProc:ChannelSet;
			if (_channelSets.hasOwnProperty(this.remoteDestination)) {
				channelSetProc = _channelSets[this.remoteDestination];
			} else {
				try {
					var channelSetNew:ChannelSet = ServerConfig.getChannelSet(this.remoteDestination);
					channelSetProc = channelSetNew
					_channelSets[this.remoteDestination] = channelSetNew;
				} catch (e:Error) {
					throw e;
				}
			}
			
			// リモートオブジェクトを更新
			service.destination = this.remoteDestination;
			service.channelSet = channelSetProc;

			// メソッド名からオペレーションを取得			
			var operation:Operation = service.getOperation(methodName) as Operation;
			operation.arguments = this.rpcParameter;

			// RPCコントローラに指定したリモートオブジェクト＆メソッドを実行依頼
			operation.send();
		}
		
		/**
		 * <p>[概 要]</p>
		 * 具象通信オブジェクトを作成します.
		 * 
		 * <p>[詳 細]</p>
		 * RemoteObjectオブジェクトを生成して返却します。
		 * 
		 * <p>[備 考]</p>
		 *
		 * @return RemoteObjectオブジェクト
		 */ 
		override protected function createConcreteService() : IEventDispatcher {
			return new RemoteObject();
		}
	}
}
