/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.nexaweb.parser;

import java.util.Vector;

import com.nexaweb.xml.Element;
import com.nexaweb.xml.xpath.XPathFactory;

/**
 * <p>[概 要] </p>
 * tableエレメントの保持する値を取得するクラスです。
 * 
 * <p>[詳 細] </p>
 * tableエレメントの値を取得する為の
 * {@link Parser#parse(Element)}を実装します。
 * 
 * <p>[備 考] </p>
 * このクラスはElementValueParserによってインスタンス化され、使用されます。<br>
 * 詳細は{@link ElementValueParser#parse(Element)}を参照して下さい。
 * 
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class TableValueParser implements Parser {

	/**
	 * <p>[概 要] </p>
	 * Protectedコンストラクタです。
	 *  
	 * <p>[詳 細] </p>
	 * デフォルト処理は有りません。
	 * 
	 * <p>[備 考] </p>
	 * tableエレメント値をパースするには
	 * {@link ElementValueParser#parse(Element)}
	 * を使用して下さい。
	 */
	protected TableValueParser() {
	}

	/**
	 * <p>[概 要] </p>
	 * tableの値を取得します。
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param table 値をパースするtableエレメント
	 */
	@SuppressWarnings("unchecked")
	public ElementValues parse(Element table) {
		ElementValues ret = new ElementValues();

		// tableエレメントのname属性を取得
		String name = table.getAttribute("name");

		// table/rowエレメントのリストを取得
		Vector<?> rows = XPathFactory.createXPath("row").evaluate(table);

		// rowエレメント数文ループ
		for (int i = 0; i < rows.size(); i++) {
			Element row = (Element) rows.get(i);
			// tableのname属性に行を表す添え字を追加。.ex)dataTable[0]
			String dimension = name + "[" + i + "]";

			// table/row/cellエレメントのリストを取得
			Vector<Element> cells = XPathFactory.createXPath("cell").evaluate(
					row);
			for (Element cell : cells) {
				// 添え字付きtableのname属性にcellのname属性を追加。.ex)dataTable[0].age
				String cellName = dimension + cell.getAttribute("name");

				// cellの値を取る
				String text = cell.getAttribute("text");
				// dataTable[0].age = cellエレメントのtext属性値
				ElementValue elementValue = new ElementValue(cellName, text);
				// 一つの値を集約
				ret.addElementValue(elementValue);
			}
		}

		return ret;
	}
}
