/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.nexaweb.util;

import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialog;
import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialogIF;

import com.nexaweb.xml.Document;
import com.nexaweb.xml.Element;
import com.nexaweb.xml.Parser;
import com.nexaweb.xml.ParserException;
import com.nexaweb.xml.ParserFactory;
import com.nexaweb.xml.events.ChangeRejectedException;
import com.nexaweb.xml.events.StructureChangeEvent;
import com.nexaweb.xml.events.StructureChangeListener;
import com.nexaweb.xml.xpath.XPath;
import com.nexaweb.xml.xpath.XPathFactory;

/**
 * <p>[概 要]</p>
 * メッセージダイアログユーティリティクラス
 * <p>[詳 細]</p>
 * <p>[備 考]</p>
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class DialogUtil {

	/** ルートエレメント名 */
	private static final String ROOT_PANE = "rootPane";
	public static final String MODAL_BACKGROUND_ID = "reffi.modaldaialogback";

	private static Document _uiDoc;

	/**
	 * <p>[概 要] プライベートコンストラクタ</p>
	 * <p>[詳 細] </p>
	 * <p>[備 考]</p>
	 */
	private DialogUtil() {
	}

	private static Document getUiDocument() {
		return _uiDoc;
	}

	/**
	 * <p>[概 要]</p>
	 * メッセージダイアログ表示
	 * <p>[詳 細]</p>
	 * <p>[備 考]</p>
	 * 
	 * @param uiDoc UIドキュメント
	 * @param cdi メッセージダイアログ情報
	 */
	public static void messageAlert(Document uiDoc, CoreDialogIF cdi) {
		DialogUtil._uiDoc = uiDoc;
		CoreDialog modalBackCdi = new CoreDialog.Builder("", "").bgColor(
				"transparent").bgImage("/images/modalBgImage.gif").maximized(
				true).showTitleBar(false).messageDialogFlg(false).id(
				MODAL_BACKGROUND_ID).build();

		Element dialog = getElement(cdi);
		String modal = dialog.getAttribute("modal");

		if (Boolean.parseBoolean(modal)) {

			uiDoc.addStructureChangeListener(new StructureChangeListener() {

				@Override
				public void beforeChildAdded(
						StructureChangeEvent structurechangeevent)
						throws ChangeRejectedException {
				}

				@Override
				public void beforeChildRemoved(StructureChangeEvent evt)
						throws ChangeRejectedException {
					// 追加されたのがElementの場合
					if (evt.getChange() instanceof Element) {

						Element source = (Element) evt.getChange();
						String id = source.getAttribute("id");
						if (("dialog".equals(source.getLocalName()) || "messageDialog"
								.equals(source.getLocalName()))
								&& !DialogUtil.MODAL_BACKGROUND_ID.equals(id)) {

							Element element = getUiDocument().getElementById(
									DialogUtil.MODAL_BACKGROUND_ID);
							if (element != null) {
								Element rootPane = DialogUtil
										.getRootPane(getUiDocument());
								rootPane.removeChild(element);
							}
						}
					}
				}

				@Override
				public void onChildAdded(
						StructureChangeEvent structurechangeevent) {
				}

				@Override
				public void onChildRemoved(
						StructureChangeEvent structurechangeevent) {
				}
			});

			showDialog(uiDoc, getElement(modalBackCdi));
		}
		showDialog(uiDoc, getElement(cdi));
	}

	/**
	 * <p>[概 要]</p>
	 * メッセージダイアログエレメントを取得します
	 * <p>[詳 細]</p>
	 * <p>[備 考]</p>
	 * 
	 * @param cdi メッセージダイアログ情報
	 * @return エレメント
	 */
	public static Element getElement(CoreDialogIF cdi) {
		Element element = null;
		try {
			Parser parser = ParserFactory.getParser();
			Document doc = parser.parseXml(cdi.getTagXml());
			element = doc.getRootElement();
		} catch (ParserException e) {
			e.printStackTrace();
		}

		return element;
	}

	/**
	 * <p>[概 要]</p>
	 * ルートペインエレメント取得
	 * <p>[詳 細]</p>
	 * <p>[備 考]</p>
	 * 
	 * @param uiDoc UIドキュメント
	 * @return エレメント
	 */
	public static Element getRootPane(Document uiDoc) {

		Element rootElement = uiDoc.getRootElement();
		XPath xpath = XPathFactory.createXPath("/ui/rootPane");
		Element rootPane = xpath.evaluateAsElement(rootElement);

		if (rootPane == null) {
			rootPane = uiDoc.createElement(ROOT_PANE);
			rootElement.appendChild(rootPane);
		}

		return rootPane;
	}

	/**
	 * <p>[概 要] ダイアログエレメントをRootPaneに追加します。</p>
	 * <p>[詳 細] </p>
	 * <p>[備 考] </p>
	 * @param uiDoc UIドキュメント
	 * @param msgDialogElement ダイアログエレメント 
	 */
	private static void showDialog(Document uiDoc, Element msgDialogElement) {
		if (msgDialogElement != null) {
			Element rootPane = getRootPane(uiDoc);
			rootPane.appendChild(msgDialogElement);
		}
	}
}
