/*
 * Copyright (c) 2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.swing.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * <p>[概 要] </p>
 * 
 * <p>[詳 細] </p>
 * 
 * <p>[備 考] </p>
 * 
 * 
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class ClassNode {

	/**  */
	public static final int CONTROLLER_NODE = 0;
	/**  */
	public static final int VIEW_NODE = 1;
	/**  */
	public static final int ACTION_NODE = 2;
	/**  */
	public static final int MODEL_NODE = 3;

	/**  */
	public double x;

	/**  */
	public double y;

	/**  */
	public double dx;

	/**  */
	public double dy;
	
	/**  */
	public boolean fixed;
	
	/**  */
	private ClassNode parent;
	
	/**  */
	private List<ClassNode> children = new ArrayList<ClassNode>();

	/**  */
	private int nodeType = CONTROLLER_NODE;

	/**  */
	private String packagePath;
	
	/**  */
	private String name;
	
	/**  */
	private double lineLength = 150d;

	
	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	public ClassNode getParent() {
		return parent;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param parent
	 */
	public void setParent(ClassNode parent) {
		this.parent = parent;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	public List<ClassNode> getChildren() {
		return children;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param children
	 */
	public void setChildren(List<ClassNode> children) {
		this.children = children;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param child
	 */
	public void addChild(ClassNode child) {
		child.setParent(this);
		this.children.add(child);
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	public int getNodeType() {
		return nodeType;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param nodeType
	 */
	public void setNodeType(int nodeType) {
		this.nodeType = nodeType;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	public String getPackagePath() {
		return packagePath;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param packagePath
	 */
	public void setPackagePath(String packagePath) {
		this.packagePath = packagePath;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	public double getLineLength() {
		return lineLength;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param lineLength
	 */
	public void setLineLength(double lineLength) {
		this.lineLength = lineLength;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param nodeType
	 * @param packagePath
	 * @param name
	 */
	public ClassNode(int nodeType,
					String packagePath,
					String name) 
	{
		this.nodeType = nodeType;
		this.packagePath = packagePath;
		this.name = name;
	}
	
	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	public int getLength() {
		return length() + 1;
	}
	
	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	private int length() {
		int cnt = getChildren().size();
		
		for(Iterator<ClassNode> it = getChildren().iterator(); it.hasNext();) {
			cnt += it.next().length();
		}
		
		return cnt;
	}

	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return
	 */
	public ClassNode[] toArray() {
		List<ClassNode> list = new ArrayList<ClassNode>();
		
		list.add(this);
		
		list = concat(list);
		
		return list.toArray(new ClassNode[0]);
	}
	
	/**
	 * <p>[概 要] </p>
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param list
	 * @return
	 */
	private List<ClassNode> concat(List<ClassNode> list) {
		list.addAll(getChildren());

		for(Iterator<ClassNode> it = getChildren().iterator(); it.hasNext();) {
			list = it.next().concat(list);
		}
		
		return list;
	}
}
