/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import jp.co.fujitsu.reffi.client.swing.action.Action;
import jp.co.fujitsu.reffi.client.swing.controller.AbstractController;
import jp.co.fujitsu.reffi.client.swing.controller.BaseController;
import jp.co.fujitsu.reffi.client.swing.controller.ClientConfig;
import jp.co.fujitsu.reffi.client.swing.controller.EventBinder;
import jp.co.fujitsu.reffi.client.swing.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.swing.listener.MessageDialogListener;
import jp.co.fujitsu.reffi.client.swing.manager.WindowManager;
import jp.co.fujitsu.reffi.client.swing.parser.ComponentValue;
import jp.co.fujitsu.reffi.client.swing.parser.ComponentValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.ComponentValues;
import jp.co.fujitsu.reffi.client.swing.util.ComponentSearchUtil;
import jp.co.fujitsu.reffi.client.swing.util.MessageDialogUtil;
import jp.co.fujitsu.reffi.client.swing.validator.ValidateError;
import jp.co.fujitsu.reffi.client.swing.validator.ValidateErrors;
import jp.co.fujitsu.reffi.client.swing.validator.Validator;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;

public abstract class AbstractAction
implements Action {
    private ParameterMapping parameterMapping;
    private AbstractController controller;

    public ParameterMapping getParameterMapping() {
        return this.parameterMapping;
    }

    public void setParameterMapping(ParameterMapping parameterMapping) {
        this.parameterMapping = parameterMapping;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
    }

    @Override
    public ParameterMapping run(ParameterMapping parameterMapping) throws Exception {
        this.parameterMapping = parameterMapping;
        return parameterMapping;
    }

    protected ValidateErrors validate(List<Validator> validators) throws Exception {
        ValidateErrors validateErrors = new ValidateErrors();
        try {
            for (Validator validator : validators) {
                Component element = validator.getComponent();
                this.returnElementStatusBeforeError(element);
            }
            for (Validator validator : validators) {
                if (validator.execute()) continue;
                validateErrors.addError(new ValidateError(validator.getComponent(), validator.getErrorMessage(), validator.getHeadWord()));
            }
        }
        catch (Exception e) {
            throw new CoreLogicException("EFC0009", e);
        }
        return validateErrors;
    }

    public void validationFault(ValidateErrors errors) {
        ClientConfig config = this.getController().getClientConfig();
        if (config.isEnableValidationFaultProcessing() && errors.hasError()) {
            for (int i = 0; i < errors.size(); ++i) {
                ValidateError error = errors.getError(i);
                Component errorComponent = error.getComponent();
                String headWord = error.getHeadWord();
                String message = error.getMessage();
                if (!(errorComponent instanceof JComponent)) continue;
                Map<Integer, Map<String, Object>> snapshot = this.getController().getErrorComponentSnapshot().get(this.getOwnWindow().hashCode());
                HashMap<String, Object> errorInfo = new HashMap<String, Object>();
                if (config.isComponentColorChangeOnValidationFault()) {
                    errorInfo.put("color", ((JComponent)errorComponent).getBackground());
                    ((JComponent)errorComponent).setBackground(config.getComponentColorOnValidationFault());
                }
                if (config.isComponentTipChangeOnValidationFault()) {
                    errorInfo.put("tip", ((JComponent)errorComponent).getToolTipText());
                    ((JComponent)errorComponent).setToolTipText(message);
                }
                snapshot.put(errorComponent.hashCode(), errorInfo);
            }
        }
    }

    protected boolean returnElementStatusBeforeError(Component component) {
        boolean ret = false;
        Map<String, Object> errorInfo = this.getController().getErrorComponentSnapshot().get(this.getOwnWindow().hashCode()).get(component.hashCode());
        if (errorInfo != null) {
            String tip;
            Color color = (Color)errorInfo.get("color");
            if (color != null) {
                component.setBackground(color);
            }
            if ((tip = (String)errorInfo.get("tip")) != null) {
                ((JComponent)component).setToolTipText(tip);
            }
            ret = true;
        }
        return ret;
    }

    public Map<Object, Object> getPermanent() {
        return this.getController().getPermanent();
    }

    public Object getPermanent(Object key) {
        return this.getController().getPermanent().get(key);
    }

    public void addPermanent(Object key, Object value) {
        this.getController().getPermanent().put(key, value);
    }

    public Object removePermanent(Object key) {
        return this.getController().getPermanent().remove(key);
    }

    protected Window getOwnWindow() {
        Window ret = null;
        Component eventSource = (Component)this.getParameterMapping().getEventSource();
        Component eventSourceParent = (Component)this.getParameterMapping().getEventSourceParent();
        ret = ComponentSearchUtil.searchWindowLevelObject(eventSource, eventSourceParent);
        return ret;
    }

    protected Window getWindow(String windowName) {
        Window ret = null;
        ret = WindowManager.getInstance().getWindowByName(windowName);
        return ret;
    }

    protected Window[] getWindows() {
        Window[] ret = null;
        ret = WindowManager.getInstance().getWindowList().toArray(new Window[1]);
        return ret;
    }

    protected Window[] getWindows(String windowName) {
        Window[] ret = null;
        ret = WindowManager.getInstance().getWindowsByName(windowName);
        return ret;
    }

    protected Component getComponent(String componentName) {
        Component ret = null;
        Window window = this.getOwnWindow();
        ret = this.getComponent(window, componentName);
        return ret;
    }

    protected Component getComponent(String windowName, String componentName) {
        Component ret = null;
        Window window = this.getWindow(windowName);
        ret = this.getComponent(window, componentName);
        return ret;
    }

    protected Component getComponent(Window window, String componentName) {
        Component ret = null;
        ret = ComponentSearchUtil.searchComponentByName(window, componentName);
        return ret;
    }

    protected Component[] getComponents(String componentName) {
        Component[] ret = null;
        Window window = this.getOwnWindow();
        ret = this.getComponents(window, componentName);
        return ret;
    }

    protected Component[] getComponents(String windowName, String componentName) {
        Component[] ret = null;
        Window window = this.getWindow(windowName);
        ret = this.getComponents(window, componentName);
        return ret;
    }

    protected Component[] getComponents(Window window, String componentName) {
        Component[] ret = null;
        ArrayList<Component> componentList = new ArrayList<Component>();
        ComponentSearchUtil.searchComponentsByName(componentList, window, componentName);
        ret = componentList.toArray(new Component[0]);
        return ret;
    }

    protected ComponentValues getComponentValues(String componentName) throws Exception {
        ComponentValues ret = null;
        Window window = this.getOwnWindow();
        ret = this.getComponentValues(window, componentName);
        return ret;
    }

    protected ComponentValues getComponentValues(String windowName, String componentName) throws Exception {
        ComponentValues ret = null;
        Window window = this.getWindow(windowName);
        ret = this.getComponentValues(window, componentName);
        return ret;
    }

    protected ComponentValues getComponentValues(Window window, String componentName) throws Exception {
        ComponentValues ret = null;
        ComponentValueParser parser = new ComponentValueParser();
        ret = (ComponentValues)parser.parse(this.getComponent(window, componentName));
        return ret;
    }

    protected Object getComponentValue(String componentName) throws Exception {
        Object ret = null;
        Window window = this.getOwnWindow();
        ret = this.getComponentValue(window, componentName);
        return ret;
    }

    protected Object getComponentValue(String windowName, String componentName) throws Exception {
        Object ret = null;
        Window window = this.getWindow(windowName);
        ret = this.getComponentValue(window, componentName);
        return ret;
    }

    protected Object getComponentValue(Window window, String componentName) throws Exception {
        Object ret = null;
        ComponentValues componentValues = this.getComponentValues(window, componentName);
        ComponentValue componentValue = componentValues.getComponentValue(0);
        ret = componentValue.getValue();
        return ret;
    }

    protected String getComponentValueAsString(String componentName) throws Exception {
        String ret = null;
        Window window = this.getOwnWindow();
        ret = this.getComponentValueAsString(window, componentName);
        return ret;
    }

    protected String getComponentValueAsString(String windowName, String componentName) throws Exception {
        String ret = null;
        Window window = this.getWindow(windowName);
        ret = this.getComponentValueAsString(window, componentName);
        return ret;
    }

    protected String getComponentValueAsString(Window window, String componentName) throws Exception {
        String ret = null;
        ComponentValues values = this.getComponentValues(window, componentName);
        Object value = values.getComponentValue();
        ret = value.toString();
        return ret;
    }

    protected void showWindow(Window window, boolean duplicate) {
        WindowManager.getInstance().showWindow(window, duplicate);
    }

    protected void showWindow(Window window, boolean duplicate, String baseWindowName, int position) {
        WindowManager.getInstance().showWindow(window, duplicate, baseWindowName, position);
    }

    protected int showMessageDialog(String message) {
        return MessageDialogUtil.showMessageDialog(this.getOwnWindow(), message, null, 1);
    }

    protected int showMessageDialog(String message, String title) {
        return MessageDialogUtil.showMessageDialog(this.getOwnWindow(), message, title, 1);
    }

    protected int showMessageDialog(String message, String title, int messageType) {
        return MessageDialogUtil.showMessageDialog(this.getOwnWindow(), message, title, messageType);
    }

    protected int showMessageDialog(String message, String title, int messageType, int buttonOption) {
        return MessageDialogUtil.showMessageDialog(this.getOwnWindow(), message, title, messageType, buttonOption);
    }

    protected void showModelessMessageDialog(String message, MessageDialogListener listener) {
        MessageDialogUtil.showModelessMessageDialog(this.getOwnWindow(), message, null, listener);
    }

    protected void showModelessMessageDialog(String message, String title, MessageDialogListener listener) {
        MessageDialogUtil.showModelessMessageDialog(this.getOwnWindow(), message, title, listener);
    }

    protected void removeListener(JComponent component, Class listenerType, EventListener listener) throws Exception {
        Field listenerListField = JComponent.class.getDeclaredField("listenerList");
        listenerListField.setAccessible(true);
        EventListenerList listenerList = (EventListenerList)listenerListField.get(component);
        listenerList.remove(listenerType, listener);
    }

    protected void addEventBindingImmediately(JComponent component, Class<? extends EventListener> listenerType, String eventType, Class<? extends AbstractAction> actionClass) {
        BaseController controller = (BaseController)this.getController();
        EventBinder eventBinder = controller.getEventBinder();
        eventBinder.addEventBindingImmediately(component, listenerType, eventType, actionClass);
    }

    public void removeEventBindingImmediately(JComponent component, Class listenerType, String eventType, EventListener listener) throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        BaseController controller = (BaseController)this.getController();
        EventBinder eventBinder = controller.getEventBinder();
        eventBinder.removeEventBindingImmediately(component, listenerType, eventType, listener);
    }
}

