/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClassNode {
    public static final int CONTROLLER_NODE = 0;
    public static final int VIEW_NODE = 1;
    public static final int ACTION_NODE = 2;
    public static final int MODEL_NODE = 3;
    public double x;
    public double y;
    public double dx;
    public double dy;
    public boolean fixed;
    private ClassNode parent;
    private List<ClassNode> children = new ArrayList<ClassNode>();
    private int nodeType = 0;
    private String packagePath;
    private String name;
    private double lineLength = 150.0;

    public ClassNode getParent() {
        return this.parent;
    }

    public void setParent(ClassNode parent) {
        this.parent = parent;
    }

    public List<ClassNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ClassNode> children) {
        this.children = children;
    }

    public void addChild(ClassNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(double lineLength) {
        this.lineLength = lineLength;
    }

    public ClassNode(int nodeType, String packagePath, String name) {
        this.nodeType = nodeType;
        this.packagePath = packagePath;
        this.name = name;
    }

    public int getLength() {
        return this.length() + 1;
    }

    private int length() {
        int cnt = this.getChildren().size();
        Iterator<ClassNode> it = this.getChildren().iterator();
        while (it.hasNext()) {
            cnt += it.next().length();
        }
        return cnt;
    }

    public ClassNode[] toArray() {
        List<ClassNode> list = new ArrayList<ClassNode>();
        list.add(this);
        list = this.concat(list);
        return list.toArray(new ClassNode[0]);
    }

    private List<ClassNode> concat(List<ClassNode> list) {
        list.addAll(this.getChildren());
        Iterator<ClassNode> it = this.getChildren().iterator();
        while (it.hasNext()) {
            list = it.next().concat(list);
        }
        return list;
    }
}

