/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.parser;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import jp.co.fujitsu.reffi.client.swing.parser.ComponentValues;
import jp.co.fujitsu.reffi.client.swing.parser.JButtonValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JCheckBoxValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JComboBoxValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JLabelValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JListValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JPasswordFieldValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JRadioButtonValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JSliderValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JSpinnerValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JTextAreaValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JTextFieldValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JTextPaneValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.JToggleButtonValueParser;
import jp.co.fujitsu.reffi.client.swing.parser.Parser;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;

public class ComponentValueParser
implements Parser {
    public static final Map<Class<? extends Component>, Class<? extends Parser>> PARSERS = new HashMap<Class<? extends Component>, Class<? extends Parser>>();

    @Override
    public ComponentValues parse(Component component) throws Exception {
        ComponentValues ret = null;
        try {
            Class<?> type = component.getClass();
            Parser parser = null;
            if (!PARSERS.containsKey(type)) {
                return null;
            }
            parser = PARSERS.get(type).newInstance();
            ret = (ComponentValues)parser.parse(component);
        }
        catch (IllegalAccessException e) {
            throw new CoreLogicException("EFC0011");
        }
        catch (InstantiationException e) {
            throw new CoreLogicException("EFC0012");
        }
        return ret;
    }

    public static void addParser(Class<? extends Component> elementName, Class<? extends Parser> parser) {
        PARSERS.put(elementName, parser);
    }

    static {
        PARSERS.put(JButton.class, JButtonValueParser.class);
        PARSERS.put(JCheckBox.class, JCheckBoxValueParser.class);
        PARSERS.put(JComboBox.class, JComboBoxValueParser.class);
        PARSERS.put(JList.class, JListValueParser.class);
        PARSERS.put(JLabel.class, JLabelValueParser.class);
        PARSERS.put(JPasswordField.class, JPasswordFieldValueParser.class);
        PARSERS.put(JSlider.class, JSliderValueParser.class);
        PARSERS.put(JSpinner.class, JSpinnerValueParser.class);
        PARSERS.put(JTextArea.class, JTextAreaValueParser.class);
        PARSERS.put(JTextField.class, JTextFieldValueParser.class);
        PARSERS.put(JTextPane.class, JTextPaneValueParser.class);
        PARSERS.put(JToggleButton.class, JToggleButtonValueParser.class);
        PARSERS.put(JRadioButton.class, JRadioButtonValueParser.class);
    }
}

