/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import jp.co.fujitsu.reffi.client.swing.manager.WindowManager;

public class ComponentSearchUtil {
    public static Component searchComponentByName(Component component, String name) {
        Component ret = null;
        if (name.equals(component.getName())) {
            return component;
        }
        if (component instanceof Container) {
            Component[] cs;
            for (Component c : cs = ((Container)component).getComponents()) {
                ret = ComponentSearchUtil.searchComponentByName(c, name);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    public static Component searchComponentByNameFromAllWindow(String name) {
        Window window;
        Component ret = null;
        Iterator<Window> i$ = WindowManager.getInstance().getWindowList().iterator();
        while (i$.hasNext() && (ret = ComponentSearchUtil.searchComponentByName(window = i$.next(), name)) == null) {
        }
        return ret;
    }

    public static void searchComponentsByName(List<Component> list, Component component, String name) {
        if (name.equals("*") || name.equals(component.getName())) {
            list.add(component);
        }
        if (component instanceof Container) {
            Component[] cs;
            for (Component c : cs = ((Container)component).getComponents()) {
                ComponentSearchUtil.searchComponentsByName(list, c, name);
            }
        }
    }

    public static Window searchWindowLevelObject(Component component) {
        while (!(component instanceof Window) && component.getParent() != null) {
            component = component.getParent();
        }
        if (component instanceof JPopupMenu) {
            component = ((JPopupMenu)component).getInvoker();
            component = ComponentSearchUtil.searchWindowLevelObject(component);
        }
        return (Window)component;
    }

    public static Window searchWindowLevelObject(Component component, Component parent) {
        if (component.getParent() == null && parent != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = parent;
        }
        return ComponentSearchUtil.searchWindowLevelObject(component);
    }
}

