/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.validator;

import java.awt.Component;
import java.util.Properties;
import jp.co.fujitsu.reffi.client.swing.parser.ComponentValue;
import jp.co.fujitsu.reffi.client.swing.parser.ComponentValues;
import jp.co.fujitsu.reffi.client.swing.validator.Validator;
import jp.co.fujitsu.reffi.common.util.ResourceUtil;

public class ByteLengthValidator
extends Validator {
    private final String MESSAGE_RESOURCE = "jp.co.fujitsu.reffi.common.exception.corelogic_message";
    private int max;
    private int min;

    public void setBytesRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public ByteLengthValidator(Component element) {
        super(element);
    }

    @Override
    public String registerErrorMessage() {
        Properties messages = ResourceUtil.instance.asProperties("jp.co.fujitsu.reffi.common.exception.corelogic_message");
        return messages.getProperty("EFC2004");
    }

    @Override
    public boolean validate(ComponentValues values) {
        int max = this.max;
        int min = this.min;
        for (int i = 0; i < values.size(); ++i) {
            ComponentValue elementValue = values.getComponentValue(i);
            String v = elementValue.getValue().toString();
            if (v.getBytes().length >= min && v.getBytes().length <= max) continue;
            return false;
        }
        return true;
    }
}

