/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.invoker;

import java.util.HashMap;
import java.util.Map;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;
import jp.co.fujitsu.reffi.server.invoker.Invoker;

public final class InvokerFactory {
    private static final String DEFAULT_INVOKER_CLASS = "jp.co.fujitsu.reffi.server.invoker.DefaultInvoker";
    private static Map<String, Invoker> invokerMap = new HashMap<String, Invoker>();

    public static Invoker getInvoker() throws CoreLogicException {
        return InvokerFactory.getInvoker(DEFAULT_INVOKER_CLASS);
    }

    public static Invoker getInvoker(String invokerClass) throws CoreLogicException {
        if (invokerMap.containsKey(invokerClass)) {
            return invokerMap.get(invokerClass);
        }
        try {
            Invoker invoker = (Invoker)Class.forName(invokerClass).newInstance();
            invokerMap.put(invokerClass, invoker);
            return invoker;
        }
        catch (ClassNotFoundException e) {
            throw new CoreLogicException("EFC9001", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CoreLogicException("EFC9001", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CoreLogicException("EFC9001", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new CoreLogicException("EFC9001", (Throwable)e);
        }
    }
}

