package jp.co.fujitsu.reffi.client.android.controller;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import android.content.Context;

public class NamingRepository {
	
	public static Map<Object, Map<Object, String>> repository = new HashMap<Object, Map<Object, String>>();

	
	public static void put(Context context, Object instance, String name) {
		Map<Object, String> map = repository.get(context);
		
		if(map == null) {
			map = new HashMap<Object, String>();
			repository.put(context, map);
		}
		map.put(instance, name);
	}
	
	public static String get(Context context, Object instance) {
		String ret = null;
		
		Map<Object, String> map = repository.get(context);
		if(map != null) {
			ret = map.get(instance);
		}
		
		return ret;
	}
	
	public static Object get(Context context, String name) {
		Object ret = null;
		
		Map<Object, String> map = repository.get(context);
		if(map != null) {
			Set<Map.Entry<Object, String>> set = map.entrySet();
			Iterator<Map.Entry<Object, String>> it = set.iterator();
			while(it.hasNext()) {
				Map.Entry<Object, String> entry = it.next();
				String value = (String)entry.getValue();
				if(value.equals(name)) {
					ret = entry.getKey();
				}
			}
		}		
		return ret;
	}
	
	public static void remove(Context context) {
		repository.remove(context);
	}
	
	public static String remove(Context context, Object instance) {
		String ret = null;
		
		Map<Object, String> map = repository.get(context);
		if(map != null) {
			ret = map.remove(instance);
		}
		return ret;
	}
	
	public static Object remove(Context context, String name) {
		Object ret = null;
		
		Map<Object, String> map = repository.get(context);
		if(map != null) {
			Object instance = get(context, name);
			if(instance != null) {
				if(repository.remove(instance) != null) {
					ret = instance;
				}
			}
		}		
		return ret;
	}
	
//	public static int nameToId(String name) {
//		int ret = 0;
//		
//		Object obj = repository.get(name);
//		if(obj instanceof View) {
//			ret = ((View)obj).getId();
//		}
//		
//		return ret;
//	}
//	
//	public static String idToName(int id) {
//		String name = null;
//		
//		Object obj = repository.get(id);
//		
//	}
}
