package jp.co.fujitsu.reffi.client.android.controller.attachment;

import java.util.HashMap;
import java.util.Map;

import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.AbsoluteLayout;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.AdapterViewFlipper;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CalendarView;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.Chronometer;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.DialerFilter;
import android.widget.DigitalClock;
import android.widget.EditText;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.Gallery;
import android.widget.GridView;
import android.widget.HorizontalScrollView;
import android.widget.ImageSwitcher;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.MediaController;
import android.widget.MultiAutoCompleteTextView;
import android.widget.NumberPicker;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.SearchView;
import android.widget.SlidingDrawer;
import android.widget.Spinner;
import android.widget.StackView;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.ToggleButton;
import android.widget.TwoLineListItem;
import android.widget.ViewAnimator;
import android.widget.ViewFlipper;
import android.widget.ViewSwitcher;
import android.widget.ZoomControls;

public class ListenerAttachmentFactory {
	
	private static Map<Class<? extends Object>, Class<? extends ListenerAttachment>> mapping = 
		new HashMap<Class<? extends Object>, Class<? extends ListenerAttachment>>();
	
	static {
		mapping.put(DatePicker.class, DatePickerListenerAttachment.class);
		mapping.put(NumberPicker.class, NumberPickerListenerAttachment.class);

//		mapping.put(AutoCompleteTextView.class, ForTextWatcherAttachment.class);
//		mapping.put(Button.class, ForTextWatcherAttachment.class);
//		mapping.put(CheckBox.class, ForTextWatcherAttachment.class);
//		mapping.put(CheckedTextView.class, ForTextWatcherAttachment.class);
//		mapping.put(Chronometer.class, ForTextWatcherAttachment.class);
//		mapping.put(CompoundButton.class, ForTextWatcherAttachment.class);
//		mapping.put(DigitalClock.class, ForTextWatcherAttachment.class);
		mapping.put(EditText.class, ForTextWatcherAttachment.class);
//		mapping.put(MultiAutoCompleteTextView.class, ForTextWatcherAttachment.class);
//		mapping.put(RadioButton.class, ForTextWatcherAttachment.class);
//		mapping.put(TextView.class, ForTextWatcherAttachment.class);
//		mapping.put(ToggleButton.class, ForTextWatcherAttachment.class);
		
//		mapping.put(WebView.class, ForAnimationListenerAttachment.class);
//		mapping.put(AbsListView.class, ForAnimationListenerAttachment.class);
//		mapping.put(AbsoluteLayout.class, ForAnimationListenerAttachment.class);
//		mapping.put(AbsSpinner.class, ForAnimationListenerAttachment.class);
//		mapping.put(AdapterView.class, ForAnimationListenerAttachment.class);
//		mapping.put(AdapterViewAnimator.class, ForAnimationListenerAttachment.class);
//		mapping.put(AdapterViewFlipper.class, ForAnimationListenerAttachment.class);
//		mapping.put(CalendarView.class, ForAnimationListenerAttachment.class);
//		mapping.put(DatePicker.class, ForAnimationListenerAttachment.class);
//		mapping.put(DialerFilter.class, ForAnimationListenerAttachment.class);
//		mapping.put(ExpandableListView.class, ForAnimationListenerAttachment.class);
//		mapping.put(FrameLayout.class, ForAnimationListenerAttachment.class);
//		mapping.put(Gallery.class, ForAnimationListenerAttachment.class);
//		mapping.put(GridView.class, ForAnimationListenerAttachment.class);
//		mapping.put(HorizontalScrollView.class, ForAnimationListenerAttachment.class);
//		mapping.put(ImageSwitcher.class, ForAnimationListenerAttachment.class);
//		mapping.put(LinearLayout.class, ForAnimationListenerAttachment.class);
//		mapping.put(ListView.class, ForAnimationListenerAttachment.class);
//		mapping.put(MediaController.class, ForAnimationListenerAttachment.class);
//		mapping.put(NumberPicker.class, ForAnimationListenerAttachment.class);
//		mapping.put(RadioGroup.class, ForAnimationListenerAttachment.class);
//		mapping.put(RelativeLayout.class, ForAnimationListenerAttachment.class);
//		mapping.put(ScrollView.class, ForAnimationListenerAttachment.class);
//		mapping.put(SearchView.class, ForAnimationListenerAttachment.class);
//		mapping.put(SlidingDrawer.class, ForAnimationListenerAttachment.class);
//		mapping.put(Spinner.class, ForAnimationListenerAttachment.class);
//		mapping.put(StackView.class, ForAnimationListenerAttachment.class);
//		mapping.put(TabHost.class, ForAnimationListenerAttachment.class);
//		mapping.put(TableLayout.class, ForAnimationListenerAttachment.class);
//		mapping.put(TableRow.class, ForAnimationListenerAttachment.class);
//		mapping.put(TabWidget.class, ForAnimationListenerAttachment.class);
//		mapping.put(TextSwitcher.class, ForAnimationListenerAttachment.class);
//		mapping.put(TimePicker.class, ForAnimationListenerAttachment.class);
//		mapping.put(TwoLineListItem.class, ForAnimationListenerAttachment.class);
//		mapping.put(ViewAnimator.class, ForAnimationListenerAttachment.class);
//		mapping.put(ViewFlipper.class, ForAnimationListenerAttachment.class);
//		mapping.put(ViewSwitcher.class, ForAnimationListenerAttachment.class);
//		mapping.put(ZoomControls.class, ForAnimationListenerAttachment.class);
		
	}
	
	public static ListenerAttachment getAttachment(Class<? extends Object> targetClass) 
		throws IllegalAccessException, InstantiationException 
	{
		ListenerAttachment ret = null;
		
		Class<? extends ListenerAttachment> cls = mapping.get(targetClass);
		if(cls != null) {
			ret = (ListenerAttachment)cls.newInstance();	
		}else{
			ret = new CommonListenerAttachment();
			
		}
		
		return ret;
	}
}
