package jp.co.fujitsu.reffi.client.android.listener;

import java.util.List;

import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources.Theme;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceScreen;
import android.preference.PreferenceActivity.Header;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ActionMode.Callback;
import android.view.ContextMenu.ContextMenuInfo;
import android.widget.ExpandableListView;
import android.widget.ListView;

public interface ActivityCallbackListener {

	
	public void attachBaseContext(Context newBase);
	
	
	public void onActionModeFinished(ActionMode mode);

	
	public void onActionModeStarted(ActionMode mode);

	
	public void onActivityResult(int requestCode, int resultCode, Intent data);

	
	public void onApplyThemeResource(Theme theme, int resid, boolean first);
	
	
	public void onAttachedToWindow();

	
	public void onAttachFragment(Fragment fragment);

	
	public void onBackPressed();

	
	public void onBuildHeaders(List<Header> target);

	
	public boolean onChildClick(ExpandableListView parent, View v, int groupPosition, int childPosition, long id);

	
	public void onChildTitleChanged(Activity childActivity, CharSequence title);
	
	
	public void onConfigurationChanged(Configuration newConfig);
	
	
	public void onContentChanged();

	
	public boolean onContextItemSelected(MenuItem item);

	
	public void onContextMenuClosed(Menu menu);

	
	public void onCreate(Bundle savedInstanceState);

	
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo);

	
	public CharSequence onCreateDescription();

	
	public Dialog onCreateDialog(int id);

	
	public Dialog onCreateDialog(int id, Bundle args);

	
	public boolean onCreateOptionsMenu(Menu menu);

	
	public boolean onCreatePanelMenu(int featureId, Menu menu);

	
	public View onCreatePanelView(int featureId);

	
	public boolean onCreateThumbnail(Bitmap outBitmap, Canvas canvas);

	
	public View onCreateView(String name, Context context, AttributeSet attrs);

	
	public View onCreateView(View parent, String name, Context context,	AttributeSet attrs);

	
	public void onDestroy();

	
	public void onDetachedFromWindow();
	
	
	public Header onGetInitialHeader();

	
	public Header onGetNewHeader();

	
	public void onGlobalLayout();

	
	public void onGroupCollapse(int groupPosition);

	
	public void onGroupExpand(int groupPosition);


	public void onHeaderClick(Header header, int position);

	
	public void onInputQueueCreated(InputQueue queue);

	
	public void onInputQueueDestroyed(InputQueue queue);

	
	public boolean onIsHidingHeaders();

	
	public boolean onIsMultiPane();

	
	public boolean onKeyDown(int keyCode, KeyEvent event);

	
	public boolean onKeyLongPress(int keyCode, KeyEvent event);

	
	public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event);

	
	public boolean onKeyShortcut(int keyCode, KeyEvent event);

	
	public boolean onKeyUp(int keyCode, KeyEvent event);

	
	public void onListItemClick(ListView l, View v, int position, long id);

	
	public void onLowMemory();

	
	public boolean onMenuItemSelected(int featureId, MenuItem item);

	
	public boolean onMenuOpened(int featureId, Menu menu);

	
	public void onNewIntent(Intent intent);

	
	public boolean onOptionsItemSelected(MenuItem item);

	
	public void onOptionsMenuClosed(Menu menu);

	
	public void onPanelClosed(int featureId, Menu menu);

	
	public void onPause();

	
	public void onPostCreate(Bundle savedInstanceState);

	
	public void onPostResume();

	
	public boolean onPreferenceStartFragment(PreferenceFragment caller,	Preference pref);

	
	public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen,	Preference preference);

	
	public void onPrepareDialog(int id, Dialog dialog);

	
	public void onPrepareDialog(int id, Dialog dialog, Bundle args);
	
	
	public boolean onPrepareOptionsMenu(Menu menu);

	
	public boolean onPreparePanel(int featureId, View view, Menu menu);

	
	public List<ResolveInfo> onQueryPackageManager(Intent queryIntent);

	
	public void onRestart();

	
	public void onRestoreInstanceState(Bundle savedInstanceState);

	
	public void onResume();

	
	public Object onRetainNonConfigurationInstance();

	
	public void onSaveInstanceState(Bundle outState);

	
	public boolean onSearchRequested();

	
	public void onSetContentView();

	
	public void onStart();

	
	public void onStop();

	
	public void onTitleChanged(CharSequence title, int color);

	
	public boolean onTouchEvent(MotionEvent event);

	
	public boolean onTrackballEvent(MotionEvent event);

	
	public void onUserInteraction();

	
	public void onUserLeaveHint();

	
	public void onWindowAttributesChanged(android.view.WindowManager.LayoutParams params);

	
	public void onWindowFocusChanged(boolean hasFocus);

	
	public ActionMode onWindowStartingActionMode(Callback callback);


}