package jp.co.fujitsu.reffi.client.android.model;

import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.content.DialogInterface;
import android.content.DialogInterface.OnDismissListener;

public class UserInteractionCore extends BaseModel {
	
	
	private AlertDialog.Builder alertBuilder;

	private AlertDialog dialog;

	

	public AlertDialog.Builder getAlertBuilder() {
		return alertBuilder;
	}

	public void setAlertBuilder(AlertDialog.Builder alertBuilder) {
		this.alertBuilder = alertBuilder;
	}

	
	
	public AlertDialog getDialog() {
		return dialog;
	}

	public void setDialog(AlertDialog dialog) {
		this.dialog = dialog;
	}

	public void init() {
		this.alertBuilder = new AlertDialog.Builder(getParameterMapping().getContext());
	}
	
	@Override
	protected void mainproc() throws Exception {
		((Activity)getParameterMapping().getContext()).runOnUiThread(new Thread(){
			public void run() {
				setDialog(createAlertBuilder(getAlertBuilder()).show());
				getDialog().setOnDismissListener(new OnDismissListener() {
					
					@Override
					public void onDismiss(DialogInterface paramDialogInterface) {
						
						ModelProcessEvent success = new ModelProcessEvent(UserInteractionCore.this);
						success.setResult(getResult());
						fireModelSuccess(success);
						
						fireModelFinished(new ModelProcessEvent(UserInteractionCore.this));
						
					}
				});
			}
		});
	}
	
	protected Builder createAlertBuilder(Builder builder) {
		return builder;
	}
}
