/*
 * Copyright (c) 2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.android.parser;

/**
 * <p>[概 要] </p>
 * コンポーネントの値を保持するクラスです。
 * 
 * <p>[詳 細] </p>
 * &lt;textField id="ageTextField" name="age" text="32"/&gt;<BR>
 * 上記のコンポーネントはname=age、value=32でこのクラスオブジェクトが生成されます。
 * 
 * <p>[備 考] </p> 
 * 
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class ComponentValue {

	/** コンポーネントのname属性です。 */
	private String name;

	/** コンポーネントの値です。 */
	private Object value;

	/**
	 * <p>[概 要] </p>
	 * nameとvalueを引数に取るコンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * 引数nameをnameフィールドに、引数valueをvalueフィールドに設定します。
	 * 
	 * <p>[備 考] </p> 
	 * 
	 * @param name コンポーネントのname属性
	 * @param value コンポーネントの値
	 */
	public ComponentValue(String name, Object value) {
		this.name = name;
		this.value = value;
		if(this.value == null){
			this.value = "";
		}
	}

	/**
	 * <p>[概 要] </p>
	 * コンポーネントのname属性を取得します。
	 * 
	 * <p>[詳 細] </p>
	 * nameフィールドを返却します。
	 * 	 
	 * <p>[備 考] </p> 
	 * 
	 * @return コンポーネントのname属性
	 */
	public String getName() {
		return name;
	}

	/**
	 * <p>[概 要] </p>
	 * コンポーネントのname属性を設定します。
	 * 
	 * <p>[詳 細] </p>
	 * nameフィールドを引数nameで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param name コンポーネントのname属性
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * <p>[概 要] </p>
	 * コンポーネントの値を取得します。
	 * 
	 * <p>[詳 細] </p>
	 * valueフィールドを返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return コンポーネントの値
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * <p>[概 要] </p>
	 * コンポーネントの値を設定します。
	 * 
	 * <p>[詳 細] </p>
	 * valueフィールドを引数valueで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param value コンポーネントの値
	 */
	public void setValue(Object value) {
		this.value = value;
	}
}
