package jp.co.fujitsu.reffi.client.android.parser;

import jp.co.fujitsu.reffi.client.android.controller.NamingRepository;
import android.view.View;
import android.widget.DatePicker;

public class DatePickerValueParser implements Parser {

	protected DatePickerValueParser(){
	}

	public ComponentValues parse(View datePickerView) {
		ComponentValues ret = new ComponentValues();

		String name = NamingRepository.get(datePickerView.getContext(), datePickerView);
		
		DatePicker datePicker = (DatePicker)datePickerView;
		String year = String.valueOf(datePicker.getYear());
		String month = String.valueOf(datePicker.getMonth() + 1);
		String day = String.valueOf(datePicker.getDayOfMonth());
		String value = year + "/" + month + "/" + day;

		ComponentValue componentValue = new ComponentValue(name, value);
		ret.addComponentValue(componentValue);

		return ret;
	}
}
