package jp.co.fujitsu.reffi.client.android.util;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;

import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import android.graphics.BitmapFactory;

public class ResultFormat {

	public static final int BYTE_ARRAY = 0;

	public static final int TEXT = 1;

	public static final int IMAGE = 2;
	
	public static final int XMLPULLPARSER = 3;
	
	public static final int JSON = 4;
	
	
	public static Object convert(byte[] data, int resultType, String charset) throws 
		UnsupportedEncodingException, 
		XmlPullParserException, 
		JSONException 
	{
		Object ret = null;
		
		switch(resultType) {
		case BYTE_ARRAY :
			ret = data;
			break;
		case TEXT :
			ret = new String(data, charset);
			break;
		case IMAGE : 
			ret = BitmapFactory.decodeByteArray(data, 0, data.length);
			break;
		case XMLPULLPARSER :
		    XmlPullParserFactory xppf = XmlPullParserFactory.newInstance();
		    xppf.setNamespaceAware(true);
		    XmlPullParser xpp = xppf.newPullParser();
		    xpp.setInput(new StringReader(new String(data, charset)));
		    ret = xpp;
		    break;
		case JSON :
			JSONObject jsonObject = new JSONObject(new String(data, charset));
			ret = jsonObject;
			break;
			
		default : 
			break;
		}
		
		return ret;
	}
}
