/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.controller;

import android.content.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.co.fujitsu.reffi.client.android.action.AbstractAction;
import jp.co.fujitsu.reffi.client.android.controller.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBinder {
    private Map<String, Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>>> bindInfo;
    private AbstractController controller;

    public Map<String, Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>>> getBindInfo() {
        return this.bindInfo;
    }

    public void setBindInfo(Map<String, Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>>> bindInfo) {
        this.bindInfo = bindInfo;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
    }

    public EventBinder(AbstractController controller) {
        this.controller = controller;
        this.bindInfo = new HashMap<String, Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>>>();
    }

    public void addEventBinding(String name, String listenerFqcn, String eventType, String actionFqcn) throws Exception {
        Class<?> listenerType = Class.forName(listenerFqcn);
        this.addEventBinding(name, listenerType, eventType, actionFqcn);
    }

    public void addEventBinding(String name, Class<? extends Object> listenerType, String eventType, String actionFqcn) throws Exception {
        Class<?> actionClass = Class.forName(actionFqcn);
        this.addEventBinding(name, listenerType, eventType, actionClass);
    }

    public void addEventBinding(String name, Class<? extends Object> listenerType, String eventType, Class<? extends AbstractAction> actionClass) {
        Map<Object, Object> listenerTypeMap = null;
        if (this.bindInfo.containsKey(name)) {
            listenerTypeMap = this.bindInfo.get(name);
        } else {
            listenerTypeMap = new HashMap();
            this.bindInfo.put(name, listenerTypeMap);
        }
        Map<String, Class<? extends AbstractAction>> eventTypeMap = null;
        if (listenerTypeMap.containsKey(listenerType)) {
            eventTypeMap = (Map)listenerTypeMap.get(listenerType);
        } else {
            eventTypeMap = new HashMap();
            listenerTypeMap.put(listenerType, eventTypeMap);
        }
        eventTypeMap.put(eventType, actionClass);
    }

    public Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>> getListenerTypeMap(String name) {
        return this.bindInfo.get(name);
    }

    public List<Class<? extends Object>> getListenerTypes(String name) {
        ArrayList<Class<? extends Object>> ret = new ArrayList<Class<? extends Object>>();
        Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(name);
        if (listenerTypeMap != null) {
            Set<Class<? extends Object>> keys = listenerTypeMap.keySet();
            for (Class<? extends Object> listener : keys) {
                ret.add(listener);
            }
        }
        return ret;
    }

    public List<String> getEventTypes(String name, Class<? extends Object> listenerType) {
        Map<String, Class<? extends AbstractAction>> eventTypeMap;
        ArrayList<String> ret = new ArrayList<String>();
        Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(name);
        if (listenerTypeMap != null && (eventTypeMap = listenerTypeMap.get(listenerType)) != null) {
            Set<String> keys = eventTypeMap.keySet();
            for (String eventType : keys) {
                ret.add(eventType);
            }
        }
        return ret;
    }

    public Class<? extends AbstractAction> getActionClass(String name, Class<? extends Object> listenerType, String eventType) {
        Map<String, Class<? extends AbstractAction>> eventTypeMap;
        Class<? extends AbstractAction> ret = null;
        Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(name);
        if (listenerTypeMap != null && (eventTypeMap = listenerTypeMap.get(listenerType)) != null) {
            ret = eventTypeMap.get(eventType);
        }
        return ret;
    }

    public boolean isEventBinding(String name) {
        return this.bindInfo.containsKey(name);
    }

    public void addEventBindingImmediately(Context context, Object viewOrActivity, String name, Class<? extends Object> listenerType, String eventType, Class<? extends AbstractAction> actionClass) throws Exception {
        this.addEventBinding(name, listenerType, eventType, actionClass);
        ArrayList<String> eventTypes = new ArrayList<String>();
        eventTypes.add(eventType);
        this.controller.addListener(context, viewOrActivity, listenerType, eventTypes);
    }

    public void removeEventBinding(int viewId) {
        this.bindInfo.remove(viewId);
    }

    public void removeEventBinding(int viewId, Class<? extends Object> listenerType) {
        Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(viewId);
        listenerTypeMap.remove(listenerType);
    }

    public void removeEventBinding(int viewId, Class<? extends Object> listenerType, String eventType) {
        Map<Class<? extends Object>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(viewId);
        Map<String, Class<? extends AbstractAction>> eventTypeMap = listenerTypeMap.get(listenerType);
        eventTypeMap.remove(eventType);
    }
}

