/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.controller;

import android.content.Context;
import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import jp.co.fujitsu.reffi.client.android.controller.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventInvocationHandler
implements InvocationHandler {
    private Context context;
    private Object eventSource;
    private AbstractController controller;
    private Class<? extends Object> listenerType;
    private List<String> eventTypes;
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
    }

    public Class getListenerType() {
        return this.listenerType;
    }

    public void setListenerType(Class listenerType) {
        this.listenerType = listenerType;
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(List<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public EventInvocationHandler(Context context, Object eventSource, AbstractController controller, Class listenerType, List<String> eventTypes) {
        this.context = context;
        this.eventSource = eventSource;
        this.controller = controller;
        this.listenerType = listenerType;
        this.eventTypes = eventTypes;
    }

    @Override
    public Object invoke(Object eventListenerProxy, Method method, Object[] args) throws Throwable {
        Boolean result = null;
        Class<?> declaringClass = method.getDeclaringClass();
        Log.d((String)"EventInvocationHandler", (String)method.getName());
        if (declaringClass == Object.class) {
            if (method.equals(hashCodeMethod)) {
                return this.proxyHashCode(eventListenerProxy);
            }
            if (method.equals(equalsMethod)) {
                return this.proxyEquals(eventListenerProxy, args[0]);
            }
            if (method.equals(toStringMethod)) {
                return this.proxyToString(eventListenerProxy);
            }
            throw new InternalError("unexpected Object method dispatched: " + method);
        }
        if (this.eventTypes.contains(method.getName())) {
            this.controller.handlerFacade(this.context, this.eventSource, args, this.listenerType, method.getName(), eventListenerProxy);
        }
        Log.d((String)"event return type", (String)method.getReturnType().toString());
        if (method.getReturnType().toString().equals("boolean")) {
            result = true;
        }
        return result;
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", null);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", null);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

