/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.android.model.BaseModel;
import jp.co.fujitsu.reffi.client.android.util.ResultFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestCore
extends BaseModel {
    public static final String GET = "GET";
    public static final String POST = "POST";
    private String uri;
    private String method = "POST";
    private List<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
    private int resultType = 0;
    private int statusCode;
    private int responseSize;
    private String inputEncoding = "UTF-8";
    private String outputEncoding = "UTF-8";
    private byte[] rawResult;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<BasicNameValuePair> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<BasicNameValuePair> parameters) {
        this.parameters = parameters;
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public void addParameters(String key, String value) {
        BasicNameValuePair pair = new BasicNameValuePair(key, value);
        this.parameters.add(pair);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(int responseSize) {
        this.responseSize = responseSize;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public byte[] getRawResult() {
        return this.rawResult;
    }

    public void setRawResult(byte[] rawResult) {
        this.rawResult = rawResult;
    }

    @Override
    protected void mainproc() throws Exception {
        HttpPost request = null;
        if (this.method.equals(POST)) {
            request = new HttpPost(this.getUri());
            if (this.getParameters().size() > 0) {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(this.getParameters(), this.getOutputEncoding()));
            }
        } else if (this.method.equals(GET)) {
            String query = "";
            if (this.getParameters().size() > 0) {
                query = "?" + URLEncodedUtils.format(this.getParameters(), (String)this.getOutputEncoding());
            }
            request = new HttpGet(this.getUri() + query);
        }
        this.preSend((HttpRequestBase)request);
        byte[] buf = this.send((HttpRequestBase)request);
        this.setRawResult(buf);
        this.setResponseSize(buf.length);
        Object result = ResultFormat.convert(buf, this.getResultType(), this.getInputEncoding());
        this.postSend(result);
        this.setResult(result);
    }

    @Override
    protected void postproc() throws Exception {
        ModelProcessEvent successEvent = new ModelProcessEvent(this);
        successEvent.setResult(this.getResult());
        this.fireModelSuccess(successEvent);
        this.fireModelFinished(new ModelProcessEvent(this));
    }

    protected void preSend(HttpRequestBase request) {
    }

    protected byte[] send(HttpRequestBase request) throws IOException, XmlPullParserException, JSONException {
        int size;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        this.setStatusCode(statusCode);
        byte[] w = new byte[1024];
        HttpEntity entity = httpResponse.getEntity();
        InputStream in = entity.getContent();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((size = in.read(w)) > 0) {
            out.write(w, 0, size);
        }
        out.close();
        in.close();
        entity.consumeContent();
        request.abort();
        client.getConnectionManager().shutdown();
        byte[] buf = out.toByteArray();
        return buf;
    }

    protected void postSend(Object result) {
    }
}

