/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.model;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.android.manager.SQLiteOpenHelperManager;
import jp.co.fujitsu.reffi.client.android.model.BaseModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteCore
extends BaseModel {
    private SQLiteOpenHelperManager manager;
    private SQLiteDatabase database;
    private String[] onCreateSql;
    private String[] onUpdateSql;
    private String databaseName;
    private SQLiteDatabase.CursorFactory cursorFactory;
    private int databaseVersion = 1;
    private List<SQLInfo> sqls = new ArrayList<SQLInfo>();
    private boolean autoClose;
    private int sqlIndex;
    private boolean transaction;

    public SQLiteOpenHelperManager getManager() {
        return this.manager;
    }

    public void setManager(SQLiteOpenHelperManager manager) {
        this.manager = manager;
    }

    public SQLiteDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(SQLiteDatabase database) {
        this.database = database;
    }

    public String[] getOnCreateSql() {
        return this.onCreateSql;
    }

    public void setOnCreateSql(String[] onCreateSql) {
        this.onCreateSql = onCreateSql;
    }

    public String[] getOnUpdateSql() {
        return this.onUpdateSql;
    }

    public void setOnUpdateSql(String[] onUpdateSql) {
        this.onUpdateSql = onUpdateSql;
    }

    public String getDatabaseName() {
        if (this.databaseName == null) {
            this.databaseName = this.getController().getClientConfig().getDefaultDatabaseName();
        }
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public SQLiteDatabase.CursorFactory getCursorFactory() {
        return this.cursorFactory;
    }

    public void setCursorFactory(SQLiteDatabase.CursorFactory cursorFactory) {
        this.cursorFactory = cursorFactory;
    }

    public int getDatabaseVersion() {
        if (this.databaseVersion == 0) {
            this.databaseVersion = this.getController().getClientConfig().getDefaultDatabaseVersion();
        }
        return this.databaseVersion;
    }

    public void setDatabaseVersion(int databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public List<SQLInfo> getSqls() {
        return this.sqls;
    }

    public void setSqls(List<SQLInfo> sqls) {
        this.sqls = sqls;
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public int getSqlIndex() {
        return this.sqlIndex;
    }

    public void setSqlIndex(int sqlIndex) {
        this.sqlIndex = sqlIndex;
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public void setTransaction(boolean transaction) {
        this.transaction = transaction;
    }

    public void addSql(String sql, Object[] args) {
        SQLInfo sqlInfo = new SQLInfo(sql, args);
        this.getSqls().add(sqlInfo);
    }

    @Override
    protected boolean preproc() throws Exception {
        this.manager = SQLiteOpenHelperManager.getInstance();
        this.manager.open(this);
        if (this.getSqls().size() == 0) {
            return false;
        }
        this.registSqls();
        return true;
    }

    @Override
    protected void mainproc() throws Exception {
        SQLiteOpenHelper helper = this.getManager().getHelper(this.getDatabaseName());
        this.setDatabase(helper.getWritableDatabase());
        if (this.isTransaction()) {
            this.getDatabase().beginTransaction();
        }
        for (int i = 0; i < this.getSqls().size(); ++i) {
            SQLInfo sqlInfo = this.getSqls().get(i);
            this.preExecute(this.getSqlIndex(), sqlInfo);
            Object ret = this.executeSql(sqlInfo);
            this.setResult(ret);
            this.postExecute(this.getSqlIndex(), sqlInfo, ret);
            ModelProcessEvent success = new ModelProcessEvent(this);
            success.setResult(this.getResult());
            this.fireModelSuccess(success);
            this.setSqlIndex(this.getSqlIndex() + 1);
        }
        if (this.isTransaction()) {
            this.getDatabase().setTransactionSuccessful();
        }
        this.fireModelFinished(new ModelProcessEvent(this));
    }

    @Override
    protected void finalproc() {
        if (this.isTransaction()) {
            this.getDatabase().endTransaction();
        }
    }

    @Override
    public void done() {
        if (this.isAutoClose()) {
            if (this.getResult() instanceof Cursor && !((Cursor)this.getResult()).isClosed()) {
                ((Cursor)this.getResult()).close();
            }
            this.getManager().close(this);
        }
    }

    protected void bindArgs(SQLiteStatement statement, Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            DatabaseUtils.bindObjectToProgram((SQLiteProgram)statement, (int)(i + 1), (Object)args[i]);
        }
    }

    protected void registSqls() {
    }

    protected void preExecute(int sqlIndex, SQLInfo sqlInfo) {
    }

    public Object executeSql(SQLInfo sqlInfo) {
        Object ret = null;
        String sql = sqlInfo.getSql().trim();
        if (sql.toLowerCase().startsWith("select")) {
            Cursor cursor;
            String[] selectionArgs = null;
            if (sqlInfo.getArgs() != null) {
                Object[] args = sqlInfo.getArgs();
                selectionArgs = (String[])Array.newInstance(String.class, args.length);
                System.arraycopy(args, 0, selectionArgs, 0, args.length);
            }
            ret = cursor = this.getDatabase().rawQuery(sql, selectionArgs);
        } else if (sql.toLowerCase().startsWith("update") || sql.toLowerCase().startsWith("delete")) {
            SQLiteStatement statement = this.getDatabase().compileStatement(sql);
            this.bindArgs(statement, sqlInfo.getArgs());
            int affectedRowCount = statement.executeUpdateDelete();
            ret = affectedRowCount;
        } else if (sql.toLowerCase().startsWith("insert")) {
            SQLiteStatement statement = this.getDatabase().compileStatement(sql);
            this.bindArgs(statement, sqlInfo.getArgs());
            long rowId = statement.executeInsert();
            ret = rowId;
        } else {
            this.getDatabase().execSQL(sql, sqlInfo.getArgs());
        }
        return ret;
    }

    protected void postExecute(int sqlIndex, SQLInfo sqlInfo, Object result) {
    }

    public class SQLInfo {
        private String sql;
        private Object[] args;

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public void setArgs(Object[] args) {
            this.args = args;
        }

        public SQLInfo(String sql, Object[] args) {
            this.sql = sql;
            this.args = args;
        }
    }
}

